<!DOCTYPE html>
<html>
	<head>
		<title>PHP multi-language framework Official Website</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
		<meta name="description" content="PHP,Multi-langual framework by @FengYi" />
		<meta name="keywords" content="PHP, PHP Frame, PHPFrame, PHP Multi language Framework, PHPMulti language Framework, PHP Multi language, PHPMulti language, by @FengYi" />
		<link rel="stylesheet" href="assets/css/main.css" />
		<link rel="stylesheet" href="assets/css/lp-icon.css" />
		<link rel="shortcut icon" href="assets/logo/logo.ico" type="image/x-icon">
		<noscript><link rel="stylesheet" href="assets/css/noscript.css" /></noscript>
	</head>
	<body class="is-preload">

		<!-- Sidebar -->
			<section id="sidebar">
				<div class="inner">
					<nav>
						<ul>
							<li><a href="#intro">Welcome</a></li>
							<li><a href="#language">Available languages</a></li>
							<li><a href="#Example">Example</a></li>
						</ul>
					</nav>
				</div>
			</section>

		<!-- Wrapper -->
			<div id="wrapper">

				<!-- Intro -->
					<section id="intro" class="wrapper style1 fullscreen fade-up">
						<div class="inner">
							<h1>PHP multi-language framework v26</h1>
							<p>This is a multilingual program implemented in a framework that is implemented in a number of different ways. Frame design not only allows you to build a website that is simple, fast, and efficient enough to satisfy you.</p>
							<ul class="actions">
								<li><a href="https://fengyi.tel/php/learn" class="button scrolly">Quick Guide</a></li>
								<li><a href="https://fengyi.tel/php/downloads" class="button primary icon solid fa-download">Download</a></li>
							</ul>
						</div>
					</section>

				<!-- Language -->
					<section id="language" class="wrapper style2 fade-up">
						<div class="inner">
							<h2>Choose your country or region.</h2>
							<h3>North America</h3>
							<dt><span class="flag-icon flag-icon-us"></span>&nbsp; <a href="javascript:lang('en-US')">United States - English</a></dt>
							<br />
							<h3>Asia Pacific</h3>
							<dt><span class="flag-icon flag-icon-cn"></span>&nbsp; <a href="javascript:lang('zh-CN')">简体中文 - 中国</a></dt>
							<dt><span class="flag-icon flag-icon-tw"></span>&nbsp; <a href="javascript:lang('zh-TW')">繁體中文 - 中國</a></dt>
							<dt><span class="flag-icon flag-icon-jp"></span>&nbsp; <a href="javascript:lang('ja-JP')">日本 - 日本語</a></dt>
							<dt><span class="flag-icon flag-icon-kr"></span>&nbsp; <a href="javascript:lang('ko-KR')">대한민국 - 한국어</a></dt>
							<br />
							<h3>Europe</h3>
							<dt><span class="flag-icon flag-icon-ru"></span>&nbsp; <a href="javascript:lang('ru-RU')">Россия - Русский</a></dt>
						</div>
					</section>

				<!-- Example -->
					<section id="Example" class="wrapper style3 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h2>Portable directory-based</h2>
									<p>Run index.php to access the Homepage directory; for other pages, please refer to Newpage.</p>
									<ul class="actions">
										<li><a href="example/01-directory" target="_blank" class="button primary fit">Demo</a></li>
										<li><a href="https://fengyi.tel/php/learn" target="_blank" class="button alt fit">Quick Guide</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt6" class="wrapper style2 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h2>STAND-ALONE VERSION &amp; PORTABLE</h2>
									<p>Use array() build an array of language structure and function to complete all operations compared with the other version, portable version is done by a document.</p>
									<ul class="actions">
										<li><a href="example/02-portable" target="_blank" class="button primary fit">Demo</a></li>
										<li><a href="https://fengyi.tel/php/learn" target="_blank" class="button alt fit">Quick Guide</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

					<section id="ExampleExt5" class="wrapper style4 spotlights">
						<section>
							<div class="content">
								<div class="inner">
									<h2>DATABASE &amp; AN ARRAY OF TYPE</h2>
									<p>Connected via PDO SQL database support for MySQL, SQLite. Using arrays (Array) feature lists all the available data.</p>
									<ul class="actions">
										<li><a href="example/03-database" target="_blank" class="button primary fit">Demo</a></li>
										<li><a href="https://fengyi.tel/php/learn" target="_blank" class="button alt fit">Quick Guide</a></li>
									</ul>
								</div>
							</div>
						</section>
					</section>

				<!-- License -->
					<section id="three" class="wrapper style1 fade-up">
						<div class="inner">
							<h2>Create a multilingual website</h2>
							<p>Unlike other frameworks, Lang-php is designed to be unlimited and offers multiple options. We believe that these scenarios give you much easier than overwriting existing rules. With a few lines of code added, you can customize the look of multiple languages for use with your web project.</p>
						</div>
					</section>

			</div>

		<!-- Footer -->
			<footer id="footer" class="wrapper style1-alt">
				<div class="inner">
					<ul class="menu">
						<li>&copy; Lang-php. All rights reserved.</li>
						<li>Design: <a href="https://fengyi.tel">Yi</a></li>
					</ul>
				</div>
			</footer>

		<!-- Scripts -->
			<script src="assets/js/jquery.min.js"></script>
			<script src="assets/js/jquery.scrollex.min.js"></script>
			<script src="assets/js/jquery.scrolly.min.js"></script>
			<script src="assets/js/browser.min.js"></script>
			<script src="assets/js/breakpoints.min.js"></script>
			<script src="assets/js/util.js"></script>
			<script src="assets/js/main.js"></script>
			<script src="assets/js/lp.js"></script>
<?php include "themes/analytics.php"; ?>
	</body>
</html>