<?php
/* @author   Yi Feng
 * @version  v26
 * @homepage https://fengyi.tel/php
 */

/* Basic Configuration */
$masterCatalogue = 'homepage';    /* Main language */

if(isSet($_GET['lang'])) {
	$lang = strtolower($_GET['lang']);
	$_SESSION['lang'] = $lang;
	$_COOKIE["lang"] = $lang;
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/', getDomain());
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/');

	$_COOKIE["lang"] = $lang;
	$_SESSION['lang'] = $lang;
	$lng = $lang;
} else if(isSet($_COOKIE['lang'])) {
	$lng = $_COOKIE['lang'];
} else {
	preg_match('/^([a-z\-]+)/i', $_SERVER['HTTP_ACCEPT_LANGUAGE'], $matches);
	$lang = strtolower($matches[1]);
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/', getDomain());
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/');
	$_SESSION['lang'] = $lang;
	$lng = $lang;
}

function getDomain() {
	$link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] .  $_SERVER['REQUEST_URI'];

	$pieces = parse_url($link);
	$domain = isset($pieces['host']) ? $pieces['host'] : '';
	if(preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)){
		return '.'.$regs['domain'];
	}
	return FALSE;
}
$global_path_temp_default = __DIR__ . '/' . $masterCatalogue . '/' . 'en-us.php';
$global_path_temp_default = str_replace("//","/",  $global_path_temp_default);
$global_path_temp_default = str_replace('\\', '/', $global_path_temp_default);

$global_path_temp = __DIR__ . '/' . $masterCatalogue . '/' . $lng . '.php';
$global_path_temp = str_replace("//","/",  $global_path_temp);
$global_path_temp = str_replace('\\', '/', $global_path_temp);
if (file_exists($global_path_temp)) {
    include_once $global_path_temp;
} elseif (file_exists($global_path_temp_default)) {
    $global_path_temp = $global_path_temp_default;
    include_once $global_path_temp;
} else {
	$ErrorPage = 'lib/' . '404.php';
	if (file_exists($ErrorPage)) {
    	include_once $ErrorPage;
	} else {
		print_r("Language file $global_path_temp not found, loading default language file en-us.php");
	}
}
?>