<?php
/* @author    Yi Feng
 * @version   v6.5
 * @homepage  https://lang-php.com
 */

/* Basic Configuration */
/* Available language */
$global_lp_all = array('en-us', 'zh-cn', 'zh-tw', 'ja-jp', 'ko-kr', 'ru-ru');

if(isSet($_GET['lang'])) {
	$lang = strtolower($_GET['lang']);
	$_SESSION['lang'] = $lang;
	$_COOKIE["lang"] = $lang;
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/', getDomain());
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/');

	if (in_array($lang, $global_lp_all)) {
		$_COOKIE["lang"] = $lang;
		$_SESSION['lang'] = $lang;
		$lng = $lang;
	} else {
		$lng = 'en-us';
	}
} else if(isSet($_COOKIE['lang'])) {
	$lang = strtolower($_COOKIE['lang']);
	if (in_array($lang, $global_lp_all)) {
		$lng = $lang;
	} else {
		$lng = 'en-us';
	}
} else {
	preg_match('/^([a-z\-]+)/i', $_SERVER['HTTP_ACCEPT_LANGUAGE'], $matches);
	$lang = strtolower($matches[1]);
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/', getDomain());
	setcookie("lang", $lang, time() + (3600 * 24 * 30), '/');
	$_COOKIE["lang"] = $lang;
	
	if (in_array($lang, $global_lp_all)) {
		$_COOKIE["lang"] = $lang;
		$_SESSION['lang'] = $lang;
		$lng = $lang;
	} else {
		$lng = 'en-us';
	}
}

function getDomain() {
	$link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] .  $_SERVER['REQUEST_URI'];

	$pieces = parse_url($link);
	$domain = isset($pieces['host']) ? $pieces['host'] : '';
	if(preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)){
		return '.'.$regs['domain'];
	}
	return FALSE;
}

$lpna = array (
	'welcome_title'  => array (
		'en-us' => 'BONUS KIT',
		'zh-cn' => '附赠套件',
		'zh-tw' => '附贈套件'),
	'lang_cfg_title' => array (
		'en-us' => 'MORE FEATURES',
		'zh-cn' => '更多功能',
		'zh-tw' => '更多功能'),
	'lang_cfg_title2' => array (
		'en-us' => 'PHP Probe',
		'zh-cn' => 'PHP 探针',
		'zh-tw' => 'PHP 探針'),
	'lang_available' => array (
		'en-us' => 'AVAILABLE LANGUAGES',
		'zh-cn' => '可用语言',
		'zh-tw' => '可用語言'),
	'lang_dark' => array (
		'en-us' => 'Dark',
		'zh-cn' => '暗',
		'zh-tw' => '暗'),
	'lang_dark_light' => array (
		'en-us' => 'Light',
		'zh-cn' => '亮',
		'zh-tw' => '亮'),
	'lang_dark_save' => array (
		'en-us' => 'Remember this',
		'zh-cn' => '记住我',
		'zh-tw' => '記住我')
);

#print_r($lpna);
?>
<?php if($_GET['action']=='phpinfo') : ?>
<?php phpinfo(); ?>
<?php else : ?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo $lpna['welcome_title'][$lng]; ?></title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="supported-color-schemes" content="dark light">
	<meta name="color-scheme" content="dark light">
	<meta name="theme-color" content="">
	<link rel="shortcut icon" href="assets/logo/logo.ico" type="image/x-icon">
	<link rel="stylesheet" href="assets/css/lp-icon.css" type="text/css" />
	<script>
		if (window.matchMedia('(prefers-color-scheme: dark)').media === 'not all') {
				document.documentElement.style.display = 'none';
				document.head.insertAdjacentHTML(
				'beforeend',
				'<link rel="stylesheet" href="assets/css/lp-light.css" onload="document.documentElement.style.display = \'\'">'
			);
		}
	</script>
	<link rel="stylesheet" href="assets/css/lp.css">
	<link rel="stylesheet" href="assets/css/lp-dark.css" media="(prefers-color-scheme: dark)">
	<link rel="stylesheet" href="assets/css/lp-light.css" media="(prefers-color-scheme: no-preference), (prefers-color-scheme: light)">
	<script src="assets/js/lp.js"></script>
	<script type="module" src="assets/js/lp-dark-mode.js"></script>
</head>
<body>
	<h1 id="logo">
		<a href="https://lang-php.com"></a>
		<br /><aside><dark-mode-toggle id="dark-mode-toggle-1" appearance="switch" dark="<?php echo $lpna['lang_dark'][$lng]; ?>" light="<?php echo $lpna['lang_dark_light'][$lng]; ?>" remember="<?php echo $lpna['lang_dark_save'][$lng]; ?>"></dark-mode-toggle></aside>
	</h1>

	<h2><?php echo $lpna['lang_cfg_title'][$lng]; ?></h2>
	<ol>
		<li><a href="?action=phpinfo">phpInfo</a></li>
		<li><a href="tz.php"><?php echo $lpna['lang_cfg_title2'][$lng]; ?></a></li>
		<li><a href="phpmyadmin">phpMyAdmin</a></li>
		<li><a href="adminer.php">adminer</a></li>
		<li><a href="phpsysinfo">phpSysInfo</a></li>
	</ol>

	<h2><?php echo $lpna['lang_available'][$lng]; ?></h2>
	<dl>
		<dt><span class="flag-icon flag-icon-us"></span>&nbsp;<a href="javascript:lang('en-US')">United States - English</a></dt>
		<dt><span class="flag-icon flag-icon-cn"></span>&nbsp;<a href="javascript:lang('zh-CN')">简体中文 - 中国</a></dt>
		<dt><span class="flag-icon flag-icon-tw"></span>&nbsp;<a href="javascript:lang('zh-TW')">繁體中文 - 中國</a></dt>
	</dl>

<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-154069938-3"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-154069938-3');
</script>
</body>
</html>
<?php endif; ?>