﻿using System;
using System.Threading;
using System.Windows.Forms;

namespace WNMP
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        /// 
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Lp.Start();
            Skin.Start();

            using (Mutex mutex = new Mutex(true, "01da9167-28d1-45c9-bcad-f31c9f8050dc", out bool IsMR))
            {
                if (IsMR)
                {
                    MainInterface Mi = new MainInterface
                    {
                        ShowInTaskbar = false,
                        Opacity = 0
                    };
                    Mi.Hide();
                    Application.Run(Mi);
                    mutex.ReleaseMutex();
                }
                else
                {
                    Application.Run(new IsSame());
                }
            }
        }
    }
}