﻿using Microsoft.Win32;
using System;
using System.Diagnostics;
using System.Threading;

namespace WNMP
{
    class BPT
    {
        public readonly MainInterface main;
        public static Thread thread_nginx, thread_php, thread_mysql;
        Sel.Action NginxAction = Sel.Action.Always, PhpAction = Sel.Action.Always, MySqlAction = Sel.Action.Always;
        public static bool NginxStatus = true, PhpStatus = true, MySqlStatus = true;
        public static bool aNginxStatus = true, aPhpStatus = true, aMySqlStatus = true;
        public static int iNginx = 0, iPhp = 0, iMySql = 0, maxchk = 2;

        public BPT(MainInterface m)
        {
            main = m;
        }

        public void Nginx()
        {
            NginxAction = Sel.Action.Always;
            NginxStatus = true;
            while (NginxStatus)
            {
                Sleep();
                switch (NginxAction)
                {
                    case Sel.Action.Always:
                        Nginx_ext();
                        break;
                    case Sel.Action.Analysis:
                        aNginxStatus = true;
                        iNginx = 0;

                        while (aNginxStatus)
                        {
                            Nginx_ext();
                            LogManager.Add("Now", "[ " + "Nginx".PadRight(10) + " ] threads, #5, Action [ Analysis ], code [ loop ], PID [ " + (int)Cfg.Nginx.GetValue("Nginx_procId") + " ], loop [ " + iNginx + " ]");

                            if (iNginx > maxchk)
                            {
                                aNginxStatus = false;
                                NginxAction = Sel.Action.Stop;
                                LogManager.Add("Now", "[ " + "Nginx".PadRight(10) + " ] threads, #6, Action [ Analysis ], code [ Stop ], PID [ " + (int)Cfg.Nginx.GetValue("Nginx_procId") + " ], loop [ stop ]");
                                break;
                            }
                            iNginx++;
                            Sleep();
                        }
                        break;
                    case Sel.Action.Stop:
                        main.Nginx_action_start_ext(Sel.Action.Error);
                        thread_nginx.Abort();
                        NginxStatus = false;
                        break;
                }
            }
        }

        void Nginx_ext()
        {
            try
            {
                if (IsProcessExists((int)Cfg.Nginx.GetValue("Nginx_procId")))
                {
                    Process processById = Process.GetProcessById((int)Cfg.Nginx.GetValue("Nginx_procId"));
                    if (processById.MainModule.FileName.ToLower() == Cfg.Pnginx.ToLower())
                    {
                        NginxAction = Sel.Action.Always;
                        aNginxStatus = false;
                        LogManager.Add("Now", "[ " + "Nginx".PadRight(10) + " ] threads, #1, Action [ " + NginxAction + " ], code [ path ], PID [ " + (int)Cfg.Nginx.GetValue("Nginx_procId") + " ], original path [ " + processById.MainModule.FileName.ToLower() + " ], contrast path [ " + Cfg.Pnginx.ToLower());
                    }
                    else
                    {
                        NginxAction = Sel.Action.Analysis;
                        aNginxStatus = true;
                        LogManager.Add("Now", "[ " + "Nginx".PadRight(10) + " ] threads, #2, Action [ " + NginxAction + " ], code [ path ], PID [ " + (int)Cfg.Nginx.GetValue("Nginx_procId") + " ], original path [ " + processById.MainModule.FileName.ToLower() + " ], contrast path [ " + Cfg.Pnginx.ToLower());
                    }
                }
                else
                {
                    NginxAction = Sel.Action.Analysis;
                    aNginxStatus = true;
                    LogManager.Add("Now", "[ " + "Nginx".PadRight(10) + " ] threads, #3, Action [ " + NginxAction + " ], code [ Not ], PID [ " + (int)Cfg.Nginx.GetValue("Nginx_procId") + " ]");
                }
            }
            catch
            {
                NginxAction = Sel.Action.Analysis;
                aNginxStatus = true;
                LogManager.Add("Now", "[ " + "Nginx".PadRight(10) + " ] threads, #4, Action [ " + NginxAction + " ], code [ e ], PID [ " + (int)Cfg.Nginx.GetValue("Nginx_procId") + " ]");
            }
        }

        public void Php()
        {
            PhpAction = Sel.Action.Always;
            PhpStatus = true;
            while (PhpStatus)
            {
                Sleep();
                switch (PhpAction)
                {
                    case Sel.Action.Always:
                        Php_ext();
                        break;
                    case Sel.Action.Analysis:
                        aPhpStatus = true;
                        iPhp = 0;

                        while (aPhpStatus)
                        {
                            Php_ext();
                            LogManager.Add("Now", "[ " + "Php".PadRight(10) + " ] threads, #5, Action [ Analysis ], code [ loop ], PID [ " + (int)Cfg.Php.GetValue("php_procId") + " ], loop [ " + iPhp + " ]");

                            if (iPhp > maxchk)
                            {
                                aPhpStatus = false;
                                PhpAction = Sel.Action.Stop;
                                LogManager.Add("Now", "[ " + "Php".PadRight(10) + " ] threads, #6, Action [ Analysis ], code [ Stop ], PID [ " + (int)Cfg.Php.GetValue("php_procId") + " ], loop [ stop ]");
                                break;
                            }
                            iPhp++;
                            Sleep();
                        }
                        break;
                    case Sel.Action.Stop:
                        main.Php_action_start_ext(Sel.Action.Error);
                        thread_php.Abort();
                        PhpStatus = false;
                        break;
                }
            }
        }

        public void Php_ext()
        {
            try
            {
                if (IsProcessExists((int)Cfg.Php.GetValue("php_procId")))
                {
                    Process processById = Process.GetProcessById((int)Cfg.Php.GetValue("php_procId"));
                    if (processById.MainModule.FileName.ToLower() == Cfg.Pphp.ToLower())
                    {
                        PhpAction = Sel.Action.Always;
                        aPhpStatus = false;
                        LogManager.Add("Now", "[ " + "Php".PadRight(10) + " ] threads, #1, Action [ " + PhpAction + " ], code [ path ], PID [ " + (int)Cfg.Php.GetValue("php_procId") + " ], original path [ " + processById.MainModule.FileName.ToLower() + " ], contrast path [ " + Cfg.Pphp.ToLower() + " ]");
                    }
                    else
                    {
                        PhpAction = Sel.Action.Analysis;
                        aPhpStatus = true;
                        LogManager.Add("Now", "[ " + "Php".PadRight(10) + " ] threads, #2, Action [ " + PhpAction + " ], code [ path ], PID [ " + (int)Cfg.Php.GetValue("php_procId") + " ], original path [ " + processById.MainModule.FileName.ToLower() + " ], contrast path [ " + Cfg.Pphp.ToLower() + " ]");
                    }
                }
                else
                {
                    PhpAction = Sel.Action.Analysis;
                    aPhpStatus = true;
                    LogManager.Add("Now", "[ " + "Php".PadRight(10) + " ] threads, #3, Action [ " + PhpAction + " ], code [ Not ], PID [ " + (int)Cfg.Php.GetValue("php_procId") + " ]");
                }
            }
            catch
            {
                PhpAction = Sel.Action.Analysis;
                aPhpStatus = true;
                LogManager.Add("Now", "[ " + "Php".PadRight(10) + " ] threads, #4, Action [ " + PhpAction + " ], code [ e ], PID [ " + (int)Cfg.Php.GetValue("php_procId") + " ]");
            }
        }
        
        public void MySql()
        {
            MySqlAction = Sel.Action.Always;
            MySqlStatus = true;
            while (MySqlStatus)
            {
                Sleep();
                switch (MySqlAction)
                {
                    case Sel.Action.Always:
                        MySQL_ext();
                        break;
                    case Sel.Action.Analysis:
                        aMySqlStatus = true;
                        iMySql = 0;

                        while (aMySqlStatus)
                        {
                            MySQL_ext();
                            LogManager.Add("Now", "[ " + "MySql".PadRight(10) + " ] threads, #5, Action [ Analysis ], code [ loop ], PID [ " + (int)Cfg.MySQL.GetValue("mysql_procId") + " ], loop [ " + iMySql + " ]");

                            if (iMySql > maxchk)
                            {
                                aMySqlStatus = false;
                                MySqlAction = Sel.Action.Stop;
                                LogManager.Add("Now", "[ " + "MySql".PadRight(10) + " ] threads, #6, Action [ Analysis ], code [ Stop ], PID [ " + (int)Cfg.MySQL.GetValue("mysql_procId") + " ], loop [ stop ]");
                                break;
                            }
                            iMySql++;
                            Sleep();
                        }
                        break;
                    case Sel.Action.Stop:
                        main.Mysql_action_start_ext(Sel.Action.Error);
                        thread_mysql.Abort();
                        MySqlStatus = false;
                        break;
                }
            }
        }

        public void MySQL_ext()
        {
            try
            {
                if (IsProcessExists((int)Cfg.MySQL.GetValue("mysql_procId")))
                {
                    Process processById = Process.GetProcessById((int)Cfg.MySQL.GetValue("mysql_procId"));
                    if (processById.MainModule.FileName.ToLower() == Cfg.Pmysql.ToLower())
                    {
                        MySqlAction = Sel.Action.Always;
                        aMySqlStatus = false;
                        LogManager.Add("Now", "[ " + "MySql".PadRight(10) + " ] threads, #1, Action [ " + MySqlAction + " ], code [ path ], PID [ " + (int)Cfg.MySQL.GetValue("mysql_procId") + " ], original path [ " + processById.MainModule.FileName.ToLower() + " ], contrast path [ " + Cfg.Pmysql.ToLower() + " ]");
                    }
                    else
                    {
                        MySqlAction = Sel.Action.Analysis;
                        aMySqlStatus = true;
                        LogManager.Add("Now", "[ " + "MySql".PadRight(10) + " ] threads, #2, Action [ " + MySqlAction + " ], code [ path ], PID [ " + (int)Cfg.MySQL.GetValue("mysql_procId") + " ], original path [ " + processById.MainModule.FileName.ToLower() + " ], contrast path [ " + Cfg.Pmysql.ToLower() + " ]");
                    }
                }
                else
                {
                    MySqlAction = Sel.Action.Analysis;
                    aMySqlStatus = true;
                    LogManager.Add("Now", "[ " + "MySql".PadRight(10) + " ] threads, #3, Action [ " + MySqlAction + " ], code [ Not ], PID [ " + (int)Cfg.MySQL.GetValue("mysql_procId") + " ]");
                }
            }
            catch
            {
                MySqlAction = Sel.Action.Analysis;
                aMySqlStatus = true;
                LogManager.Add("Now", "[ " + "MySql".PadRight(10) + " ] threads, #4, Action [ " + MySqlAction + " ], code [ e ], PID [ " + (int)Cfg.MySQL.GetValue("mysql_procId") + " ]");
            }
        }

        public static void Killprocess(string aa)
        {
            foreach (Process myProc in Process.GetProcesses())
            {
                if (myProc.ProcessName == aa)
                    myProc.Kill();
            }
        }

        public static bool IsProcessExists(int iProcessID)
        {
            foreach (Process p in Process.GetProcesses())
            {
                if (p.Id == iProcessID)
                    return true;
            }
            return false;
        }

        static void Sleep()
        {
            Thread.Sleep(3000);
        }

        public static bool IsBT()
        {
            PerformanceCounter systemUpTime = new PerformanceCounter("System", "System Up Time");
            systemUpTime.NextValue();
            TimeSpan upTimeSpan = TimeSpan.FromSeconds(systemUpTime.NextValue());
            string CTime = DateTime.Now.Subtract(upTimeSpan).ToString();

            if ((string)Cfg.UI.GetValue("BootTime") == null)
                Cfg.UI.SetValue("BootTime", "No");

            if (CTime == (string)Cfg.UI.GetValue("BootTime"))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static void SetBT()
        {
            PerformanceCounter systemUpTime = new PerformanceCounter("System", "System Up Time");
            systemUpTime.NextValue();
            TimeSpan upTimeSpan = TimeSpan.FromSeconds(systemUpTime.NextValue());
            string CTime = DateTime.Now.Subtract(upTimeSpan).ToString();

            if (CTime != (string)Cfg.UI.GetValue("BootTime"))
            {
                Cfg.UI.SetValue("BootTime", CTime);
                //Cfg.Nginx.SetValue("Nginx_procId", 65536, RegistryValueKind.DWord);
                //Cfg.Php.SetValue("php_procId", 65536, RegistryValueKind.DWord);
                //Cfg.MySQL.SetValue("mysql_procId", 65536, RegistryValueKind.DWord);
            }
        }
    }
}