﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Threading;
using System.Windows.Forms;

namespace WNMP
{
    public partial class MainInterface : Form
    {
        #region var
        Sel.Action BtnNginxMode = Sel.Action.OnStandby, BtnPhpMode = Sel.Action.OnStandby, BtnMySqlMode = Sel.Action.OnStandby;
        BPT thread_nginx, thread_php, thread_mysql;
        Skin thread_DarkCheck;
        #endregion

        public MainInterface()
        {
            InitializeComponent();
            CheckForIllegalCrossThreadCalls = false;
        }
        
        #region Language
        private void SetLanguage()
        {
            this.Text = Lp.Get("app_full_name");

            // tab page1
            select_page_1.Text = Lp.Get("tab_console");
            select_page_2.Text = Lp.Get("tab_setting");
            select_page_3.Text = Lp.Get("tab_about");

            // Console Menu
            tab_console_select.Text = Lp.Get("menu_select");
            tab_console_status.Text = Lp.Get("tab_console_status");
            tab_console_modules.Text = Lp.Get("tab_console_modules");
            tab_console_action.Text = Lp.Get("tab_console_action");

            // Nginx
            switch (BtnNginxMode)
            {
                case Sel.Action.Start:
                    nginx_action_start.Text = Lp.Get("tab_console_action_start");
                    nginx_control_status.Text = Lp.Get("tab_console_status_nostart");
                    break;
                case Sel.Action.Stop:
                    nginx_action_start.Text = Lp.Get("tab_console_action_stop");
                    nginx_control_status.Text = Lp.Get("tab_console_status_running");
                    break;
                case Sel.Action.Error:
                    nginx_action_start.Text = Lp.Get("tab_console_action_start");
                    nginx_control_status.Text = Lp.Get("tab_console_status_nostart");
                    break;
                case Sel.Action.OnStandby:
                    nginx_action_start.Text = Lp.Get("tab_console_action_start");
                    nginx_control_status.Text = Lp.Get("tab_console_status_onhit");
                    break;
                case Sel.Action.NoInst:
                    nginx_action_start.Text = Lp.Get("tab_console_action_start");
                    nginx_control_status.Text = Lp.Get("Msg_been_installation_not");
                    break;
            }

            switch (BtnPhpMode)
            {
                case Sel.Action.Start:
                    php_action_start.Text = Lp.Get("tab_console_action_start");
                    php_control_status.Text = Lp.Get("tab_console_status_nostart");
                    break;
                case Sel.Action.Stop:
                    php_action_start.Text = Lp.Get("tab_console_action_stop");
                    php_control_status.Text = Lp.Get("tab_console_status_running");
                    break;
                case Sel.Action.Error:
                    php_action_start.Text = Lp.Get("tab_console_action_start");
                    php_control_status.Text = Lp.Get("tab_console_status_nostart");
                    break;
                case Sel.Action.OnStandby:
                    php_action_start.Text = Lp.Get("tab_console_action_start");
                    php_control_status.Text = Lp.Get("tab_console_status_onhit");
                    break;
                case Sel.Action.NoInst:
                    php_action_start.Text = Lp.Get("tab_console_action_start");
                    php_control_status.Text = Lp.Get("Msg_been_installation_not");
                    break;
            }

            switch (BtnMySqlMode)
            {
                case Sel.Action.Start:
                    mysql_action_start.Text = Lp.Get("tab_console_action_start");
                    mysql_control_status.Text = Lp.Get("tab_console_status_nostart");
                    break;
                case Sel.Action.Stop:
                    mysql_action_start.Text = Lp.Get("tab_console_action_stop");
                    mysql_control_status.Text = Lp.Get("tab_console_status_running");
                    break;
                case Sel.Action.Error:
                    mysql_action_start.Text = Lp.Get("tab_console_action_start");
                    mysql_control_status.Text = Lp.Get("tab_console_status_nostart");
                    break;
                case Sel.Action.OnStandby:
                    mysql_action_start.Text = Lp.Get("tab_console_action_start");
                    mysql_control_status.Text = Lp.Get("tab_console_status_onhit");
                    break;
                case Sel.Action.NoInst:
                    mysql_action_start.Text = Lp.Get("tab_console_action_start");
                    mysql_control_status.Text = Lp.Get("Msg_been_installation_not");
                    break;
            }

            // 动作按钮
            nginx_action_admin.Text = Lp.Get("tab_console_action_admin");
            php_action_admin.Text = Lp.Get("tab_console_action_admin");
            mysql_action_admin.Text = Lp.Get("tab_console_action_admin");
            nginx_action_config.Text = Lp.Get("tab_console_action_config");
            php_action_config.Text = Lp.Get("tab_console_action_config");
            mysql_action_config.Text = Lp.Get("tab_console_action_config");
            nginx_action_logs.Text = Lp.Get("tab_console_action_logs");
            php_action_logs.Text = Lp.Get("tab_console_action_logs");
            mysql_action_logs.Text = Lp.Get("tab_console_action_logs");

            // 动作
            menu_select_ext_kill.Text = Lp.Get("tab_console_action_stop") + " [ " + Lp.Get("Msg_chosen") + " ]";
            menu_select_ext_rerun.Text = Lp.Get("tab_console_action_resert") + " [ " + Lp.Get("Msg_chosen") + " ]";
            menu_select_ext_all_kill.Text = Lp.Get("tab_console_action_stop") + " [ " + Lp.Get("tab_console_action_killall") + " ]";

            // tab page2
            // 设置
            tab_setting_color.Text = Lp.Get("tab_setting_Themes");
            tab_setting_editor.Text = Lp.Get("tab_setting_editor");
            Menu_editor_select.Text = Lp.Get("menu_select");
            Menu_editor_Clear.Text = Lp.Get("menu_clear");
            tab_setting_browser.Text = Lp.Get("tab_setting_browser");
            menu_browser_select.Text = Lp.Get("menu_select");
            menu_browser_clear.Text = Lp.Get("menu_clear");
            tab_console_auto.Text = Lp.Get("menu_auto");
            tab_setting_launch_and_login.Text = Lp.Get("tab_setting_launch_and_login");
            StartBegin.Text = Lp.Get("tab_setting_auto_boot");
            tab_setting_Main_interface.Text = Lp.Get("tab_setting_Main_interface");
            tab_setting_runtime.Text = Lp.Get("Msg_Runtime");
            isSkip.Text = Lp.Get("Msg_been_installation_Skip");
            TopMust.Text = Lp.Get("tab_setting_TopMust");
            Run_Hide_Main.Text = Lp.Get("tab_setting_Run_Hide_Main");
            tab_setting_Close_main_panel.Text = Lp.Get("tab_setting_Close_main_panel");
            Close_Hide.Text = Lp.Get("tab_setting_Close_Hide");
            Close_Select_App_Exit.Text = Lp.Get("tab_setting_Close_Select_App_Exit");
            Close_All_App_Exit.Text = Lp.Get("tab_setting_Close_All_App_Exit");
            Close_Exit.Text = Lp.Get("tab_setting_Close_Exit");
            isPrompt.Text = Lp.Get("tab_setting_isPrompt");
            tab_setting_color.Text = Lp.Get("Color_Choose");
            Color_Choose_Dark.Text = Lp.Get("Color_Choose_Dark");
            Color_Choose_Light.Text = Lp.Get("Color_Choose_Light");
            IsUseTheme.Text = Lp.Get("IsUseTheme");
            setting_theme_msg_title.Text = Lp.Get("setting_theme_msg_title");
            setting_theme_msg_ok.Text = Lp.Get("ok");
            setting_theme_msg_canel.Text = Lp.Get("cancel");

            // tab page3
            app_pi.Text = Lp.Get("app_pi");
            app_name.Text = Lp.Get("app_name");
            app_full_name.Text = Lp.Get("app_full_name");
            app_version.Text = Lp.Get("app_version");
            app_about.Text = Lp.Get("app_about");
            app_author.Text = Lp.Get("app_author");
            app_version_num.Text = Application.ProductVersion;

            // 按钮菜单
            menu_select_ext_in_operation.Text = Lp.Get("menu_select") + " [ " + Lp.Get("tab_console_status_running") + " ]";
            menu_select_ext_not_running.Text = Lp.Get("menu_select") + " [ " + Lp.Get("tab_console_status_nostart") + " ]";
            menu_select_ext_all.Text = Lp.Get("menu_select") + " [ " + Lp.Get("Msg_all") + " ]";
            menu_select_ext_clear.Text = Lp.Get("Msg_clear") + " [ " + Lp.Get("Msg_all") + " ]";
            menu_auto_ext_all.Text = Lp.Get("menu_select") + " [ " + Lp.Get("Msg_all") + " ]";
            menu_auto_ext_clear.Text = Lp.Get("Msg_cancel") + " [ " + Lp.Get("Msg_all") + " ]";

            // nginx
            menu_nginx_port.Text = Lp.Get("port_title");
            menu_nginx_browsr.Text = Lp.Get("Msg_open_browser_folder") + menu_nginx_browsr.AccessibleDescription;
            menu_php_browser.Text = Lp.Get("Msg_open_browser_folder") + menu_php_browser.AccessibleDescription;

            // mysql
            menu_mysql_port.Text = Lp.Get("port_title");
            menu_mysql_browser.Text = Lp.Get("Msg_open_browser_folder") + menu_mysql_browser.AccessibleDescription;
            menu_mysql_phpmyadmin_browsr.Text = Lp.Get("Msg_open_browser_folder") + menu_mysql_phpmyadmin_browsr.AccessibleDescription;

            // php
            menu_php_port.Text = Lp.Get("port_title");
            menu_php_logs_browser.Text = Lp.Get("Msg_open_browser_folder") + menu_php_logs_browser.AccessibleDescription;

            menu_nginx_logs_browsr.Text = Lp.Get("Msg_open_browser_folder") + menu_nginx_logs_browsr.AccessibleDescription;
            menu_mysql_logs_browser.Text = Lp.Get("Msg_open_browser_folder") + menu_mysql_logs_browser.AccessibleDescription;

            // 选择菜单 日志
            menu_log_copy_selectd.Text = Lp.Get("Msg_copy") + " [ " + Lp.Get("Msg_chosen") + " ]";
            menu_log_copy_all.Text = Lp.Get("Msg_copy") + " [ " + Lp.Get("Msg_all") + " ]";
            menu_log_clear.Text = Lp.Get("Msg_clear") + " [ " + Lp.Get("Msg_all") + " ]";
            isLog_Time_title.Text = Lp.Get("isLog_Time_title");
            isSave_Local.Text = Lp.Get("isSave_Local");
            isLog_Time_left.Text = Lp.Get("save_day_left");
            isLog_Time_right.Text = Lp.Get("save_day_right");
            save_day_open.Text = Lp.Get("save_day_open");
            isLog_Time_browser.Text = Lp.Get("save_day_browser");

            // 语言
            tab_lp_change.Text = Lp.Get("tab_lp_change");
            tab_lp_na.Text = Lp.Get("tab_lp_na");
            tab_lp_ap.Text = Lp.Get("tab_lp_ap");

            // 通知栏
            ShowAndHide.Text = Lp.Get("ShowAndHide");
            Exit_Application.Text = Lp.Get("closed");

            // 选择语言
            switch (Lp.Lang)
            {
                case "en-US":
                    this.Font = new Font("Microsoft Sans Serif", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(0)));
                    lp_dynamic_flat.Image = global::WNMP.Properties.Resources.lp_us;
                    lp_dynamic_text.Text = "United States - English";
                    Msg(Sel.Type.Setting, "UI Language: United States - English");
                    break;
                case "zh-CN":
                    this.Font = new Font("Microsoft YaHei", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(0)));
                    lp_dynamic_flat.Image = global::WNMP.Properties.Resources.lp_cn;
                    lp_dynamic_text.Text = "中国 - 简体中文";
                    Msg(Sel.Type.Setting, "UI 语言：中国 - 简体中文");
                    break;
                case "zh-TW":
                    this.Font = new Font("Microsoft YaHei", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(0)));
                    lp_dynamic_flat.Image = global::WNMP.Properties.Resources.tw;
                    lp_dynamic_text.Text = "中國 - 繁體中文";
                    Msg(Sel.Type.Setting, "UI 語言：中國 - 繁體中文");
                    break;
                case "ko-KR":
                    this.Font = new Font("Microsoft Sans Serif", 9F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(0)));
                    lp_dynamic_flat.Image = global::WNMP.Properties.Resources.kr;
                    lp_dynamic_text.Text = "대한민국 - 한국어";
                    Msg(Sel.Type.Setting, "UI 언어 : 대한민국 - 한국어");
                    break;
            }
        }
        #endregion

        #region Dark Mode
        public void Dark()
        {
            switch ((string)Cfg.UI.GetValue("isDark"))
            {
                case "Dark":
                    this.Icon = global::WNMP.Properties.Resources.Yi_white;
                    ShowAndHide.Image = global::WNMP.Properties.Resources.home_dark;
                    Exit_Application.Image = global::WNMP.Properties.Resources.exit_dark;

                    // menu nginx
                    menu_nginx_logs_access_log.Image = global::WNMP.Properties.Resources.log_dark;
                    menu_nginx_logs_error_log.Image = global::WNMP.Properties.Resources.log_dark;
                    menu_nginx_port.Image = global::WNMP.Properties.Resources.port_dark;
                    menu_nginx_conf.Image = global::WNMP.Properties.Resources.setting_dark;
                    menu_nginx_browsr.Image = global::WNMP.Properties.Resources.open_dark;
                    menu_nginx_logs_browsr.Image = global::WNMP.Properties.Resources.open_dark;

                    // menu mysql
                    menu_mysql_logs_error_logs.Image = global::WNMP.Properties.Resources.log_dark;
                    menu_mysql_port.Image = global::WNMP.Properties.Resources.port_dark;
                    menu_mysql_my_ini.Image = global::WNMP.Properties.Resources.setting_dark;
                    menu_mysql_phpmyadmin.Image = global::WNMP.Properties.Resources.setting_dark;
                    menu_mysql_browser.Image = global::WNMP.Properties.Resources.open_dark;
                    menu_mysql_phpmyadmin_browsr.Image = global::WNMP.Properties.Resources.open_dark;
                    menu_mysql_logs_browser.Image = global::WNMP.Properties.Resources.open_dark;

                    // php
                    menu_php_port.Image = global::WNMP.Properties.Resources.port_dark;
                    menu_php_ini.Image = global::WNMP.Properties.Resources.setting_dark;
                    menu_php_browser.Image = global::WNMP.Properties.Resources.open_dark;
                    menu_php_logs_errors.Image = global::WNMP.Properties.Resources.log_dark;
                    menu_php_logs_browser.Image = global::WNMP.Properties.Resources.open_dark;

                    // select
                    menu_select_ext_in_operation.Image = global::WNMP.Properties.Resources.check_all_dark;
                    menu_select_ext_not_running.Image = global::WNMP.Properties.Resources.check_all_dark;
                    menu_select_ext_all.Image = global::WNMP.Properties.Resources.select_dark;
                    menu_select_ext_clear.Image = global::WNMP.Properties.Resources.checked_card_dark;
                    menu_select_ext_rerun.Image = global::WNMP.Properties.Resources.reset_dark;
                    menu_select_ext_kill.Image = global::WNMP.Properties.Resources.stop_dark;
                    menu_select_ext_all_kill.Image = global::WNMP.Properties.Resources.stop_dark;

                    // auto
                    menu_auto_ext_all.Image = global::WNMP.Properties.Resources.select_dark;
                    menu_auto_ext_clear.Image = global::WNMP.Properties.Resources.checked_card_dark;

                    // log
                    menu_log_copy_selectd.Image = global::WNMP.Properties.Resources.copy_dark;
                    menu_log_copy_all.Image = global::WNMP.Properties.Resources.copy_dark;
                    menu_log_clear.Image = global::WNMP.Properties.Resources.checked_card_dark;
                    menu_browser_select.Image = global::WNMP.Properties.Resources.setting_dark;
                    Menu_editor_select.Image = global::WNMP.Properties.Resources.setting_dark;

                    Main_notify.Icon = global::WNMP.Properties.Resources.Yi_white;
                    Menu_editor_Clear.Image = global::WNMP.Properties.Resources.reset_dark;
                    menu_browser_clear.Image = global::WNMP.Properties.Resources.reset_dark;
                    app_logo.Image = global::WNMP.Properties.Resources.pYi_Dark;

                    Skin.SetThemes(Sel.Style.Dark, this);
                    break;
                case "Light":
                    this.Icon = global::WNMP.Properties.Resources.Yi;
                    ShowAndHide.Image = global::WNMP.Properties.Resources.Home;
                    Exit_Application.Image = global::WNMP.Properties.Resources.exit;

                    // menu nginx
                    menu_nginx_logs_access_log.Image = global::WNMP.Properties.Resources.log;
                    menu_nginx_logs_error_log.Image = global::WNMP.Properties.Resources.log;
                    menu_nginx_port.Image = global::WNMP.Properties.Resources.port;
                    menu_nginx_conf.Image = global::WNMP.Properties.Resources.setting;
                    menu_nginx_browsr.Image = global::WNMP.Properties.Resources.open;
                    menu_nginx_logs_browsr.Image = global::WNMP.Properties.Resources.open;

                    // menu mysql
                    menu_mysql_logs_error_logs.Image = global::WNMP.Properties.Resources.log;
                    menu_mysql_port.Image = global::WNMP.Properties.Resources.port;
                    menu_mysql_my_ini.Image = global::WNMP.Properties.Resources.setting;
                    menu_mysql_phpmyadmin.Image = global::WNMP.Properties.Resources.setting;
                    menu_mysql_browser.Image = global::WNMP.Properties.Resources.open;
                    menu_mysql_phpmyadmin_browsr.Image = global::WNMP.Properties.Resources.open;
                    menu_mysql_logs_browser.Image = global::WNMP.Properties.Resources.open;

                    // php
                    menu_php_port.Image = global::WNMP.Properties.Resources.port;
                    menu_php_ini.Image = global::WNMP.Properties.Resources.setting;
                    menu_php_browser.Image = global::WNMP.Properties.Resources.open;
                    menu_php_logs_errors.Image = global::WNMP.Properties.Resources.log;
                    menu_php_logs_browser.Image = global::WNMP.Properties.Resources.open;

                    // select
                    menu_select_ext_in_operation.Image = global::WNMP.Properties.Resources.check_all;
                    menu_select_ext_not_running.Image = global::WNMP.Properties.Resources.check_all;
                    menu_select_ext_all.Image = global::WNMP.Properties.Resources.select;
                    menu_select_ext_clear.Image = global::WNMP.Properties.Resources.checked_card;
                    menu_select_ext_rerun.Image = global::WNMP.Properties.Resources.reset;
                    menu_select_ext_kill.Image = global::WNMP.Properties.Resources.stop;
                    menu_select_ext_all_kill.Image = global::WNMP.Properties.Resources.stop;

                    // auto
                    menu_auto_ext_all.Image = global::WNMP.Properties.Resources.select;
                    menu_auto_ext_clear.Image = global::WNMP.Properties.Resources.checked_card;

                    // log
                    menu_log_copy_selectd.Image = global::WNMP.Properties.Resources.copy;
                    menu_log_copy_all.Image = global::WNMP.Properties.Resources.copy;
                    menu_log_clear.Image = global::WNMP.Properties.Resources.checked_card;
                    menu_browser_select.Image = global::WNMP.Properties.Resources.setting;
                    Menu_editor_select.Image = global::WNMP.Properties.Resources.setting;

                    Main_notify.Icon = global::WNMP.Properties.Resources.Yi;
                    Menu_editor_Clear.Image = global::WNMP.Properties.Resources.reset;
                    menu_browser_clear.Image = global::WNMP.Properties.Resources.reset;
                    app_logo.Image = global::WNMP.Properties.Resources.pYi;

                    Skin.SetThemes(Sel.Style.Light, this);
                    break;
            }
        }
        #endregion

        #region check software select
        public void CheckSelect()
        {
            #region Nginx
            if (Cfg.install_nginx)
            {
                if (Cfg.Nginx.GetValue("Nginx_procId") == null)
                    Cfg.Nginx.SetValue("Nginx_procId", 65536, RegistryValueKind.DWord);

                if (BPT.IsBT())
                {
                    if (BPT.IsProcessExists((int)Cfg.Nginx.GetValue("Nginx_procId")))
                    {
                        nginx_action_start.Text = Lp.Get("tab_console_action_stop");
                        nginx_control_status.Text = Lp.Get("tab_console_status_running");
                        nginx_pid.Text = Cfg.Nginx.GetValue("Nginx_procId").ToString();
                        nginx_port.Text = (string)Cfg.Nginx.GetValue("nginx_http_port") + "," + (string)Cfg.Nginx.GetValue("nginx_https_port");
                        BtnNginxMode = Sel.Action.Stop;
                        Invoke(new Action(() => BPThread(Sel.App.Nginx, Sel.Action.Start)));
                        Msg(Sel.Type.Nginx, Lp.Get("tab_console_status_started"));
                    }
                    else
                    {
                        if (Start_App_Nginx.Checked)
                            Invoke(new Action(() => Nginx_action_start_ext(Sel.Action.Start)));
                    }
                }
                else
                {
                    if (Start_App_Nginx.Checked)
                        Invoke(new Action(() => Nginx_action_start_ext(Sel.Action.Start)));
                }
            }
            else
            {
                Msg(Sel.Type.Nginx, Lp.Get("Msg_been_installation_not"));
            }
            #endregion

            #region PHP
            if (Cfg.install_php)
            {
                if (Cfg.Php.GetValue("php_procId") == null)
                    Cfg.Php.SetValue("php_procId", 65536, RegistryValueKind.DWord);

                if (BPT.IsBT())
                {
                    if (BPT.IsProcessExists((int)Cfg.Php.GetValue("php_procId")))
                    {
                        php_pid.Text = Cfg.Php.GetValue("php_procId").ToString();
                        php_action_start.Text = Lp.Get("tab_console_action_stop");
                        php_control_status.Text = Lp.Get("tab_console_status_running");
                        php_port.Text = (string)Cfg.Php.GetValue("php_port");
                        BtnPhpMode = Sel.Action.Stop;
                        Invoke(new Action(() => BPThread(Sel.App.Php, Sel.Action.Start)));
                        Msg(Sel.Type.Php, Lp.Get("tab_console_status_started"));
                    }
                    else
                    {
                        if (Start_App_Php.Checked)
                            Invoke(new Action(() => Php_action_start_ext(Sel.Action.Start)));
                    }
                }
                else
                {
                    if (Start_App_Php.Checked)
                        Invoke(new Action(() => Php_action_start_ext(Sel.Action.Start)));
                }
            }
            else
            {
                Msg(Sel.Type.Php, Lp.Get("Msg_been_installation_not"));
            }
            #endregion

            #region MySql
            if (Cfg.install_mysql)
            {
                if (Cfg.MySQL.GetValue("mysql_procId") == null)
                    Cfg.MySQL.SetValue("mysql_procId", 65536, RegistryValueKind.DWord);

                if (BPT.IsBT())
                {
                    if (BPT.IsProcessExists((int)Cfg.MySQL.GetValue("mysql_procId")))
                    {
                        mysql_pid.Text = Cfg.MySQL.GetValue("mysql_procId").ToString();
                        mysql_port.Text = (string)Cfg.MySQL.GetValue("mysql_port");
                        Mysql_get_port();
                        mysql_action_start.Text = Lp.Get("tab_console_action_stop");
                        mysql_control_status.Text = Lp.Get("tab_console_status_running");
                        BtnMySqlMode = Sel.Action.Stop;
                        Invoke(new Action(() => BPThread(Sel.App.MySql, Sel.Action.Start)));
                        Msg(Sel.Type.MySql, Lp.Get("tab_console_status_started"));
                    }
                    else
                    {
                        if (Start_App_MySql.Checked)
                        {
                            BtnMySqlMode = Sel.Action.Stop;
                            Invoke(new Action(() => Mysql_action_start_ext(Sel.Action.Start)));
                        }
                    }
                }
                else
                {
                    if (Start_App_MySql.Checked)
                    {
                        BtnMySqlMode = Sel.Action.Stop;
                        Invoke(new Action(() => Mysql_action_start_ext(Sel.Action.Start)));
                    }
                }
            }
            else
            {
                Msg(Sel.Type.MySql, Lp.Get("Msg_been_installation_not"));
            }
            #endregion

            Invoke(new Action(() => BPT.SetBT()));
        }
        #endregion

        #region Form Load
        private void Main_Load(object sender, EventArgs e)
        {
            Invoke(new Action(() => SetLanguage()));
            Invoke(new Action(() => Check_main_process()));
            Invoke(new Action(() => Dark()));

            #region 开机时自动启动 Yi
            if (Cfg.Startup.GetValue("Yi") == null)
            {
                StartBegin.Checked = false;
            }
            else
            {
                StartBegin.Checked = true;
            }
            #endregion

            #region editor
            if ((string)Cfg.UI.GetValue("editor") != null)
                change_editor_name.Text = (string)Cfg.UI.GetValue("editor");
            #endregion

            #region browser
            if ((string)Cfg.UI.GetValue("browser") != null)
                change_editor_browser.Text = (string)Cfg.UI.GetValue("browser");
            #endregion

            #region php port
            if ((string)Cfg.Php.GetValue("php_port") == null)
                Cfg.Php.SetValue("php_port", "9000");

            switch ((string)Cfg.Nginx.GetValue("nginx"))
            {
                case "On":
                    Start_App_Nginx.Checked = true;
                    break;
                case "Off":
                    Start_App_Nginx.Checked = false;
                    break;
            }
            #endregion

            #region nginx Port and status
            switch ((string)Cfg.Nginx.GetValue("nginx"))
            {
                case "On":
                    Start_App_Nginx.Checked = true;
                    break;
                case "Off":
                    Start_App_Nginx.Checked = false;
                    break;
            }

            /* http 80 */
            if ((string)Cfg.Nginx.GetValue("nginx_http_port") == null)
                Cfg.Nginx.SetValue("nginx_http_port", "80");

            /* http 443 */
            if ((string)Cfg.Nginx.GetValue("nginx_https_port") == null)
                Cfg.Nginx.SetValue("nginx_https_port", "443");

            if ((string)Cfg.Nginx.GetValue("nginx") == null)
            {
                Cfg.Nginx.SetValue("nginx", "Off");
            }
            else
            {
                if ((string)Cfg.Nginx.GetValue("nginx") != "On" &&
                    (string)Cfg.Nginx.GetValue("nginx") != "Off")
                {
                    Cfg.Nginx.SetValue("nginx", "Off");
                }
            }

            switch ((string)Cfg.Nginx.GetValue("nginx"))
            {
                case "On":
                    Start_App_Nginx.Checked = true;
                    break;
                case "Off":
                    Start_App_Nginx.Checked = false;
                    break;
            }
            #endregion

            #region Php
            if ((string)Cfg.Php.GetValue("php") == null)
            {
                Cfg.Php.SetValue("php", "Off");
            }
            else
            {
                if ((string)Cfg.Php.GetValue("php") != "On" &&
                    (string)Cfg.Php.GetValue("php") != "Off")
                {
                    Cfg.Php.SetValue("php", "Off");
                }
            }

            switch ((string)Cfg.Php.GetValue("php"))
            {
                case "On":
                    Start_App_Php.Checked = true;
                    break;
                case "Off":
                    Start_App_Php.Checked = false;
                    break;
            }
            #endregion

            #region MySql
            if ((string)Cfg.MySQL.GetValue("MySql") == null)
            {
                Cfg.MySQL.SetValue("MySql", "Off");
            }
            else
            {
                if ((string)Cfg.MySQL.GetValue("MySql") != "On" &&
                    (string)Cfg.MySQL.GetValue("MySql") != "Off")
                {
                    Cfg.MySQL.SetValue("MySql", "Off");
                }
            }

            switch ((string)Cfg.MySQL.GetValue("MySql"))
            {
                case "On":
                    Start_App_MySql.Checked = true;
                    break;
                case "Off":
                    Start_App_MySql.Checked = false;
                    break;
            }
            #endregion

            #region Log Use
            if ((string)Cfg.Log.GetValue("isSave_Local") == null)
            {
                Cfg.Log.SetValue("isSave_Local", "Off");
            }
            else
            {
                if ((string)Cfg.Log.GetValue("isSave_Local") != "On" &&
                    (string)Cfg.Log.GetValue("isSave_Local") != "Off")
                {
                    Cfg.Log.SetValue("isSave_Local", "Off");
                }
            }

            switch ((string)Cfg.Log.GetValue("isSave_Local"))
            {
                case "On":
                    isSave_Local.Checked = true;
                    break;
                case "Off":
                    isSave_Local.Checked = false;
                    break;
            }

            if ((string)Cfg.Log.GetValue("isSave_log") == null)
            {
                Cfg.Log.SetValue("isSave_log", "Off");
            }
            else
            {
                if ((string)Cfg.Log.GetValue("isSave_log") != "On" &&
                    (string)Cfg.Log.GetValue("isSave_log") != "Off")
                {
                    Cfg.Log.SetValue("isSave_log", "Off");
                }
            }

            switch ((string)Cfg.Log.GetValue("isSave_log"))
            {
                case "On":
                    isLog_Time_left.Checked = true;
                    isLog_Time.Enabled = true;
                    break;
                case "Off":
                    isLog_Time_left.Checked = false;
                    isLog_Time.Enabled = false;
                    break;
            }

            if (Cfg.Log.GetValue("Name") == null)
                LogManager.TimeVerify();

            if (Cfg.Log.GetValue("isLog_Time") == null)
                Cfg.Log.SetValue("isLog_Time", 7, RegistryValueKind.DWord);

            isLog_Time.Value = (int)Cfg.Log.GetValue("isLog_Time");

            Invoke(new Action(() => LogManager.Clear()));

            #endregion

            #region Color
            if ((string)Cfg.UI.GetValue("isDark_dynamic") == null)
            {
                Cfg.UI.SetValue("isDark_dynamic", "Off");
            }
            else
            {
                if ((string)Cfg.UI.GetValue("isDark_dynamic") != "On" &&
                    (string)Cfg.UI.GetValue("isDark_dynamic") != "Off")
                {
                    Cfg.UI.SetValue("isDark_dynamic", "Off");
                }
            }

            switch ((string)Cfg.UI.GetValue("isDark_dynamic"))
            {
                case "On":
                    IsUseTheme.Checked = true;
                    break;
                case "Off":
                    IsUseTheme.Checked = false;
                    break;
            }
            #endregion

            #region 始终保持在其它窗口前端
            switch ((string)Cfg.UI.GetValue("TopMust"))
            {
                case "On":
                    this.TopMost = true;
                    TopMust.Checked = true;
                    break;
                case "Off":
                    this.TopMost = false;
                    TopMust.Checked = false;
                    break;
            }
            #endregion

            #region 关闭主面板时
            if ((string)Cfg.UI.GetValue("After_Closing") == null)
            {
                Cfg.UI.SetValue("After_Closing", "Hide");
            }
            else
            {
                if ((string)Cfg.UI.GetValue("After_Closing") != "Hide" &&
                    (string)Cfg.UI.GetValue("After_Closing") != "Exit" &&
                    (string)Cfg.UI.GetValue("After_Closing") != "Select" &&
                    (string)Cfg.UI.GetValue("After_Closing") != "ExitAll")
                {
                    Cfg.UI.SetValue("After_Closing", "Hide");
                }
            }

            switch ((string)Cfg.UI.GetValue("After_Closing"))
            {
                case "Hide":
                    Close_Hide.Checked = true;
                    break;
                case "Select":
                    Close_Select_App_Exit.Checked = true;
                    break;
                case "Exit":
                    Close_Exit.Checked = true;
                    break;
                case "ExitAll":
                    Close_All_App_Exit.Checked = true;
                    break;
            }

            if ((string)Cfg.UI.GetValue("isPrompt") == null)
            {
                Cfg.UI.SetValue("isPrompt", "Off");
            }
            else
            {
                if ((string)Cfg.UI.GetValue("isPrompt") != "On" &&
                    (string)Cfg.UI.GetValue("isPrompt") != "Off")
                {
                    Cfg.UI.SetValue("isPrompt", "Off");
                }
            }

            switch ((string)Cfg.UI.GetValue("isPrompt"))
            {
                case "On":
                    isPrompt.Checked = true;
                    break;
                case "Off":
                    isPrompt.Checked = false;
                    break;
            }
            #endregion

            Invoke(new Action(() => CheckSelect()));

            #region 启动后是否隐藏主界面
            if ((string)Cfg.UI.GetValue("IsHide") == null)
            {
                Cfg.UI.SetValue("IsHide", "Off");
            }
            else
            {
                if ((string)Cfg.UI.GetValue("IsHide") != "On" &&
                    (string)Cfg.UI.GetValue("IsHide") != "Off")
                {
                    Cfg.UI.SetValue("IsHide", "Off");
                }
            }

            switch ((string)Cfg.UI.GetValue("IsHide"))
            {
                case "On":
                    Invoke(new Action(() => PageStatus(true, 1)));
                    Run_Hide_Main.Checked = true;
                    break;
                case "Off":
                    Invoke(new Action(() => PageStatus(false, 2)));
                    Run_Hide_Main.Checked = false;
                    break;
            }
            #endregion

            Cfg.isRoll = true;
            RefreshScroll();
        }
        #endregion

        private void Check_main_process()
        {
            if (File.Exists(Cfg.Pnginx))
            {
                Cfg.install_nginx = true;
            }
            else
            {
                Cfg.install_nginx = false;
                BtnNginxMode = Sel.Action.NoInst;
                nginx_control_status.Text = Lp.Get("Msg_been_installation_not");
            }

            if (File.Exists(Cfg.Pphp))
            {
                Cfg.install_php = true;
            }
            else
            {
                Cfg.install_php = false;
                BtnPhpMode = Sel.Action.NoInst;
                php_control_status.Text = Lp.Get("Msg_been_installation_not");
            }

            if (File.Exists(Cfg.Pmysql))
            {
                Cfg.install_mysql = true;
            }
            else
            {
                Cfg.install_mysql = false;
                BtnMySqlMode = Sel.Action.NoInst;
                mysql_control_status.Text = Lp.Get("Msg_been_installation_not");
            }
        }

        private void Tab_console_select_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            menu_select_ext.Show(Cursor.Position);
        }

        private void Select_in_operation_Click(object sender, EventArgs e)
        {
            if (BtnNginxMode != Sel.Action.Stop)
            {
                select_nginx.Checked = false;
            }
            else
            {
                select_nginx.Checked = true;
            }

            if (BtnPhpMode != Sel.Action.Stop)
            {
                select_php.Checked = false;
            }
            else
            {
                select_php.Checked = true;
            }

            if (BtnMySqlMode != Sel.Action.Stop)
            {
                select_mysql.Checked = false;
            }
            else
            {
                select_mysql.Checked = true;
            }
        }

        private void Select_not_running_Click(object sender, EventArgs e)
        {
            if (BtnNginxMode != Sel.Action.Start &&
                BtnNginxMode != Sel.Action.Error &&
                BtnNginxMode != Sel.Action.OnStandby)
            {
                select_nginx.Checked = false;
            }
            else
            {
                select_nginx.Checked = true;
            }

            if (BtnPhpMode != Sel.Action.Start &&
                BtnPhpMode != Sel.Action.Error &&
                BtnPhpMode != Sel.Action.OnStandby)
            {
                select_php.Checked = false;
            }
            else
            {
                select_php.Checked = true;
            }

            if (BtnMySqlMode != Sel.Action.Start &&
                BtnMySqlMode != Sel.Action.Error &&
                BtnMySqlMode != Sel.Action.OnStandby)
            {
                select_mysql.Checked = false;
            }
            else
            {
                select_mysql.Checked = true;
            }
        }

        private void Select_all_Click(object sender, EventArgs e)
        {
            select_nginx.Checked = true;
            select_php.Checked = true;
            select_mysql.Checked = true;
        }

        private void Select_clear_Click(object sender, EventArgs e)
        {
            select_nginx.Checked = false;
            select_php.Checked = false;
            select_mysql.Checked = false;
        }

        private void Menu_select_ext_kill_Click(object sender, EventArgs e)
        {
            var selmsg = string.Empty;

            if (select_nginx.Checked)
                selmsg += "1";

            if (select_php.Checked)
                selmsg += "1";

            if (select_mysql.Checked)
                selmsg += "1";

            if (selmsg != "")
            {
                if (select_nginx.Checked)
                {
                    if (Cfg.install_nginx)
                    {
                        Killprocess("Yi_nginx");
                        Invoke(new Action(() => BPThread(Sel.App.Nginx, Sel.Action.Stop)));

                        nginx_pid.Text = string.Empty;
                        nginx_port.Text = string.Empty;
                    }
                    else
                    {
                        Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
                    }
                }

                if (select_php.Checked)
                {
                    if (Cfg.install_php)
                    {
                        Killprocess("Yi_php");
                        Invoke(new Action(() => BPThread(Sel.App.Php, Sel.Action.Stop)));

                        php_pid.Text = string.Empty;
                        php_port.Text = string.Empty;
                    }
                    else
                    {
                        Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
                    }
                }

                if (select_mysql.Checked)
                {
                    if (Cfg.install_mysql)
                    {
                        Killprocess("Yi_mysqld");
                        Invoke(new Action(() => BPThread(Sel.App.MySql, Sel.Action.Stop)));

                        mysql_pid.Text = string.Empty;
                        mysql_port.Text = string.Empty;
                    }
                    else
                    {
                        Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
                    }
                }
            }
            else
            {
                Msg(Sel.Type.Action, Lp.Get("Msg_no_chosen"));
            }
        }

        private void Menu_select_ext_rerun_Click(object sender, EventArgs e)
        {
            var selmsg = string.Empty;

            if (select_nginx.Checked)
                selmsg += "1";

            if (select_php.Checked)
                selmsg += "1";

            if (select_mysql.Checked)
                selmsg += "1";

            if (selmsg != "")
            {
                if (select_nginx.Checked)
                {
                    if (Cfg.install_mysql)
                    {
                        Killprocess("Yi_nginx");
                        Invoke(new Action(() => BPThread(Sel.App.Nginx, Sel.Action.Stop)));
                        Start_nginx();
                    }
                    else
                    {
                        Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
                    }
                }

                if (select_php.Checked)
                {
                    if (Cfg.install_php)
                    {
                        Killprocess("Yi_php");
                        Invoke(new Action(() => BPThread(Sel.App.Php, Sel.Action.Stop)));
                        Start_php();
                    }
                    else
                    {
                        Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
                    }
                }

                if (select_mysql.Checked)
                {
                    if (Cfg.install_mysql)
                    {
                        Killprocess("Yi_mysqld");
                        Invoke(new Action(() => BPThread(Sel.App.MySql, Sel.Action.Stop)));
                        Start_mysql();
                    }
                    else
                    {
                        Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
                    }
                }
            }
            else
            {
                Msg(Sel.Type.Action, Lp.Get("Msg_no_chosen"));
            }
        }

        private void Start_App_Nginx_CheckedChanged(object sender, EventArgs e)
        {
            if (Start_App_Nginx.Checked)
            {
                Cfg.Nginx.SetValue("nginx", "On");
                Msg(Sel.Type.Nginx, Lp.Get("Msg_startup_services"));
            }
            else
            {
                Cfg.Nginx.SetValue("nginx", "Off");
                Msg(Sel.Type.Nginx, Lp.Get("Msg_Set_off_service"));
            }
        }

        private void Start_App_Php_CheckedChanged(object sender, EventArgs e)
        {
            if (Start_App_Php.Checked)
            {
                Cfg.Php.SetValue("php", "On");
                Msg(Sel.Type.Php, Lp.Get("Msg_startup_services"));
            }
            else
            {
                Cfg.Php.SetValue("php", "Off");
                Msg(Sel.Type.Php, Lp.Get("Msg_Set_off_service"));
            }
        }

        private void Start_App_MySql_CheckedChanged(object sender, EventArgs e)
        {
            if (Start_App_MySql.Checked)
            {
                Cfg.MySQL.SetValue("MySql", "On");
                Msg(Sel.Type.MySql, Lp.Get("Msg_startup_services"));
            }
            else
            {
                Cfg.MySQL.SetValue("MySql", "Off");
                Msg(Sel.Type.MySql, Lp.Get("Msg_Set_off_service"));
            }
        }

        private void StartBegin_CheckedChanged(object sender, EventArgs e)
        {
            if (StartBegin.Checked)
            {
                Cfg.Startup.SetValue("Yi", '"' + Application.ExecutablePath.ToString() + '"');
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_auto_boot"));
            }
            else
            {
                Cfg.Startup.DeleteValue("Yi", false);
                Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("tab_setting_auto_boot"));
            }
        }

        private void TopMust_CheckedChanged(object sender, EventArgs e)
        {
            if (TopMust.Checked)
            {
                Cfg.UI.SetValue("TopMust", "On");
                this.TopMost = true;
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_TopMust"));
            }
            else
            {
                Cfg.UI.SetValue("TopMust", "Off");
                this.TopMost = false;
                Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("tab_setting_TopMust"));
            }
        }

        private void Run_Hide_Main_CheckedChanged(object sender, EventArgs e)
        {
            if (Run_Hide_Main.Checked)
            {
                Cfg.UI.SetValue("IsHide", "On");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_Run_Hide_Main"));
            }
            else
            {
                Cfg.UI.SetValue("IsHide", "Off");
                Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("tab_setting_Run_Hide_Main"));
            }
        }

        private void Close_Hide_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Hide.Checked)
            {
                Cfg.UI.SetValue("After_Closing", "Hide");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_Close_Hide"));
            }
        }

        private void Close_Select_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Select_App_Exit.Checked)
            {
                Cfg.UI.SetValue("After_Closing", "Select");
                Cfg.UI.SetValue("After_Closing_Last", "Select");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_Close_Select_App_Exit"));
            }
        }

        private void Close_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Exit.Checked)
            {
                Cfg.UI.SetValue("After_Closing", "Exit");
                Cfg.UI.SetValue("After_Closing_Last", "Exit");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_Close_Exit"));
            }
        }

        private void Close_All_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_All_App_Exit.Checked)
            {
                Cfg.UI.SetValue("After_Closing", "ExitAll");
                Cfg.UI.SetValue("After_Closing_Last", "ExitAll");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_Close_All_App_Exit"));
            }
        }

        private void IsPrompt_CheckedChanged(object sender, EventArgs e)
        {
            if (isPrompt.Checked)
            {
                Cfg.UI.SetValue("isPrompt", "On");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("tab_setting_isPrompt"));
            }
            else
            {
                Cfg.UI.SetValue("isPrompt", "Off");
                Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("tab_setting_isPrompt"));
            }
        }

        #region Main Close Event
        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                // Pause events

                switch ((string)Cfg.UI.GetValue("isPrompt"))
                {
                    case "On":
                        CloseEvent(e);
                        break;
                    case "Off":
                        if ((string)Cfg.UI.GetValue("After_Closing") == "Hide")
                        {
                            if (Cfg.close_save)
                            {
                                if (isPrompt.Checked)
                                {
                                    ActiveClose("quick");
                                }
                                else
                                {
                                    ActiveClose("main");
                                }
                            }
                            else
                            {
                                ActiveClose("main");
                            }
                        }
                        else
                        {
                            ActiveClose("main");
                        }
                        break;
                }

                Cfg.close_save = false;
                return;
            }
            e.Cancel = false;
        }

        #region ext close event
        public void CloseEvent(FormClosingEventArgs e)
        {
            switch ((string)Cfg.UI.GetValue("After_Closing"))
            {
                case "Hide":
                    if (Cfg.close_save)
                    {
                        ActiveClose("quick");
                    }
                    else
                    {
                        PageStatus(true, 1);
                    }
                    e.Cancel = true;
                    break;
                case "Select":
                    if (Start_App_Php.Checked)
                        Killprocess("Yi_php");

                    if (Start_App_MySql.Checked)
                        Killprocess("Yi_mysqld");

                    if (Start_App_Nginx.Checked)
                        Killprocess("Yi_nginx");

                    Close_Select_App_Exit.Checked = true;
                    e.Cancel = false;
                    break;
                case "Exit":
                    Dispose();
                    e.Cancel = false;
                    break;
                case "ExitAll":
                    Killprocess("Yi_php");
                    Killprocess("Yi_mysqld");
                    Killprocess("Yi_nginx");
                    e.Cancel = false;
                    break;
            }
        }
        #endregion

        #region ext Close page
        void ActiveClose(string page)
        {
            switch (page)
            {
                case "main":
                    IsClose Close_Main = new IsClose(this);
                    Close_Main.ShowDialog();
                    break;
                case "quick":
                    IsCloseQuick Close_Quick = new IsCloseQuick(this);
                    Close_Quick.ShowDialog();
                    break;
            }
        }
        #endregion
        #endregion

        public void Killprocess(string aa)
        {
            Msg(Sel.Type.Service, Lp.Get("Msg_Close_process") + " [ " + aa + " ]");
            BPT.Killprocess(aa);
        }

        public void Msg(Sel.Type var, string message)
        {
            string source;
            switch (var)
            {
                case Sel.Type.Service:
                    source = Lp.Get("type_service");
                    break;
                case Sel.Type.Action:
                    source = Lp.Get("tab_console_action");
                    break;
                case Sel.Type.Setting:
                    source = Lp.Get("tab_setting");
                    break;
                case Sel.Type.Editor:
                    source = Lp.Get("tab_setting_editor");
                    break;
                case Sel.Type.Browser:
                    source = Lp.Get("tab_setting_browser");
                    break;
                case Sel.Type.Runtime:
                    source = Lp.Get("Msg_Runtime");
                    break;
                case Sel.Type.Admin:
                    source = Lp.Get("tab_console_action_admin");
                    break;
                case Sel.Type.Nginx:
                    source = "Nginx";
                    break;
                case Sel.Type.Php:
                    source = "Php";
                    break;
                case Sel.Type.MySql:
                    source = "MySql";
                    break;
                default:
                    source = "*";
                    break;
            }

            DateTime dt = DateTime.Now;

            if (string.IsNullOrWhiteSpace(MsgInfo.Text))
            {
                Invoke(new Action(() => MsgInfo.AppendText(dt.ToString("MM-dd HH:mm:ss") + " [ " + source + " ] " + message)));
            }
            else
            {
                Invoke(new Action(() => MsgInfo.AppendText(Environment.NewLine + dt.ToString("MM-dd HH:mm:ss") + " [ " + source + " ] " + message)));
            }

            if ((string)Cfg.Log.GetValue("isSave_Local") == "On")
                Invoke(new Action(() => LogManager.Add(String.Format("{0:yyyy-MM-dd HH:mm:ss fff}", dt), "[ " + source.PadRight(10) + " ] " + message)));

            RefreshScroll();
        }

        void RefreshScroll()
        {
            if (Cfg.isRoll)
            {
                #region 滚到最后一行
                MsgInfo.ScrollToCaret();
                MsgInfo.Select(MsgInfo.Text.Length, 0);
                MsgInfo.Focus();
                #endregion
            }
        }

        private void ShowAndHide_Click(object sender, EventArgs e)
        {
            switch (ShowAndHide.AccessibleDescription)
            {
                case "1":
                    Cfg.isShowHide = false;
                    ShowAndHide.AccessibleDescription = "2";
                    PageStatus(false, 2);
                    break;
                case "2":
                    PageStatus(true, 1);
                    break;
            }
        }

        public void PageStatus(bool isShow, int type)
        {
            if (isShow)
            {
                Cfg.isShowHide = true;
            }
            else
            {
                Cfg.isShowHide = false;
            }

            switch (type)
            {
                case 1:
                    ShowAndHide.AccessibleDescription = "1";
                    break;
                case 2:
                    ShowAndHide.AccessibleDescription = "2";
                    break;
            }

            if (Cfg.isShowHide)
            {
                if (this.WindowState == FormWindowState.Normal)
                    this.WindowState = FormWindowState.Minimized;
                this.ShowInTaskbar = false;
                this.Opacity = 0;
                this.Hide();
            }
            else
            {
                if (this.WindowState == FormWindowState.Minimized)
                    this.WindowState = FormWindowState.Normal;
                this.ShowInTaskbar = true;
                this.Opacity = 100;
                this.Show();
                this.Activate();

                RefreshScroll();
            }
        }

        private void Exit_Application_Click(object sender, EventArgs e)
        {
            Cfg.close_save = true;
            PageStatus(false, 2);
            this.Close();
        }

        private void NotifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            PageStatus(false, 2);
        }

        #region Nginx, PHP, MySql
        #region 全局动作
        #region 动作 Nginx
        private void Nginx_action_start_Click(object sender, EventArgs e)
        {
            switch (BtnNginxMode)
            {
                case Sel.Action.Start:
                    Nginx_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.Stop:
                    Nginx_action_start_ext(Sel.Action.Stop);
                    break;
                case Sel.Action.Error:
                    Nginx_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.OnStandby:
                    Nginx_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.NoInst:
                    Nginx_action_start_ext(Sel.Action.NoInst);
                    break;
            }
        }

        public void Nginx_action_start_ext(Sel.Action mode)
        {
            switch (mode)
            {
                case Sel.Action.Start:
                    Invoke(new Action(() => Start_nginx()));
                    break;
                case Sel.Action.Stop:
                    BtnNginxMode = Sel.Action.Start;
                    nginx_action_start.Text = Lp.Get("tab_console_action_start");
                    nginx_control_status.Text = Lp.Get("tab_console_status_nostart");
                    nginx_pid.Text = string.Empty;
                    nginx_port.Text = string.Empty;
                    Invoke(new Action(() => Killprocess("Yi_nginx")));
                    Invoke(new Action(() => BPThread(Sel.App.Nginx, Sel.Action.Stop)));
                    break;
                case Sel.Action.Error:
                    BtnNginxMode = Sel.Action.Start;
                    nginx_action_start.Text = Lp.Get("tab_console_action_start");
                    nginx_control_status.Text = Lp.Get("tab_console_status_nostart");
                    nginx_pid.Text = string.Empty;
                    nginx_port.Text = string.Empty;
                    Invoke(new Action(() => BPThread(Sel.App.Nginx, Sel.Action.Stop)));
                    break;
                case Sel.Action.OnStandby:
                    BtnNginxMode = Sel.Action.Start;
                    break;
                case Sel.Action.NoInst:
                    BtnNginxMode = Sel.Action.NoInst;
                    Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
                    break;
            }
        }

        public void Start_nginx()
        {
            BtnNginxMode = Sel.Action.Stop;
            nginx_action_start.Text = Lp.Get("tab_console_action_stop");
            nginx_control_status.Text = Lp.Get("tab_console_status_running");
            Killprocess("Yi_nginx");
            if (Cfg.install_nginx)
            {
                var p = new Process();
                p.StartInfo.FileName = Cfg.Pnginx;
                p.StartInfo.Arguments = "-p " + Cfg.MD + "\\nginx";
                p.StartInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
                Cfg.status_nginx = p.Start();
                try
                {
                    nginx_action_start.Text = Lp.Get("tab_console_action_stop");
                    nginx_control_status.Text = Lp.Get("tab_console_status_running");
                    nginx_pid.Text = p.Id.ToString();
                    nginx_port.Text = (string)Cfg.Nginx.GetValue("nginx_http_port") + "," + (string)Cfg.Nginx.GetValue("nginx_https_port");
                    Cfg.Nginx.SetValue("Nginx_procId", p.Id, RegistryValueKind.DWord);
                    BtnNginxMode = Sel.Action.Stop;
                    Invoke(new Action(() => BPThread(Sel.App.Nginx, Sel.Action.Start)));
                    Msg(Sel.Type.Nginx, Lp.Get("tab_console_status_started"));
                }
                catch
                {
                    nginx_action_start.Text = Lp.Get("tab_console_action_start");
                    nginx_control_status.Text = Lp.Get("tab_console_status_nostart");
                    BtnNginxMode = Sel.Action.Start;
                    Msg(Sel.Type.Nginx, Lp.Get("Msg_Startup_failed"));
                }
            }
            else
            {
                nginx_action_start.Text = Lp.Get("tab_console_action_start");
                nginx_control_status.Text = Lp.Get("tab_console_status_nostart");
                BtnNginxMode = Sel.Action.NoInst;
                Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
            }
        }
        #endregion

        private void Nginx_action_admin_Click(object sender, EventArgs e)
        {
            switch (BtnNginxMode)
            {
                case Sel.Action.Start:
                    Msg(Sel.Type.Nginx, Lp.Get("Msg_no_start_admin"));
                    break;
                case Sel.Action.Stop:
                    switch (BtnPhpMode)
                    {
                        case Sel.Action.Start:
                            Msg(Sel.Type.Php, Lp.Get("Msg_no_start_admin"));
                            break;
                        case Sel.Action.Stop:
                            GlobalBrowser("http://127.0.0.1");
                            break;
                        case Sel.Action.Error:
                            Msg(Sel.Type.Php, Lp.Get("Msg_no_start_admin"));
                            break;
                        case Sel.Action.OnStandby:
                            Msg(Sel.Type.Php, Lp.Get("Msg_no_start_admin"));
                            break;
                        case Sel.Action.NoInst:
                            Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
                            break;
                    }
                    break;
                case Sel.Action.Error:
                    Msg(Sel.Type.Nginx, Lp.Get("Msg_no_start_admin"));
                    break;
                case Sel.Action.OnStandby:
                    Msg(Sel.Type.Nginx, Lp.Get("Msg_no_start_admin"));
                    break;
                case Sel.Action.NoInst:
                    Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
                    break;
            }
        }

        private void Nginx_action_config_Click(object sender, EventArgs e)
        {
            if (Cfg.install_nginx)
            {
                menu_nginx.Show(Cursor.Position);
            }
            else
            {
                Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
            }
        }

        private void Nginx_action_logs_Click(object sender, EventArgs e)
        {
            if (Cfg.install_nginx)
            {
                menu_nginx_logs.Show(Cursor.Position);
            }
            else
            {
                Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
            }
        }

        #region 菜单按钮
        private void Menu_nginx_port_Click(object sender, EventArgs e)
        {
            Port _Port = new Port(this, Sel.Type.Nginx);
            _Port.ShowDialog();
        }

        private void Menu_nginx_1_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\nginx\\conf\\nginx.conf";
            GlobalOpenFile(path);
        }

        private void Menu_nginx_browsr_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.MD + "\\nginx");
        }

        private void Menu_nginx_access_log_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\nginx\\logs\\access.log";
            GlobalOpenFile(path);
        }

        private void Menu_nginx_error_log_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\nginx\\logs\\error.log";
            GlobalOpenFile(path);
        }

        private void Menu_nginx_logs_browsr_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.MD + "\\nginx\\logs");
        }
        #endregion
        #endregion

        #region 动作 PHP
        private void Php_action_start_Click(object sender, EventArgs e)
        {
            switch (BtnPhpMode)
            {
                case Sel.Action.Start:
                    Php_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.Stop:
                    Php_action_start_ext(Sel.Action.Stop);
                    break;
                case Sel.Action.Error:
                    Php_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.OnStandby:
                    Php_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.NoInst:
                    Php_action_start_ext(Sel.Action.NoInst);
                    break;
            }
        }

        public void Php_action_start_ext(Sel.Action mode)
        {
            switch (mode)
            {
                case Sel.Action.Start:
                    Start_php();
                    break;
                case Sel.Action.Stop:
                    BtnPhpMode = Sel.Action.Start;
                    php_action_start.Text = Lp.Get("tab_console_action_start");
                    php_control_status.Text = Lp.Get("tab_console_status_nostart");
                    php_pid.Text = string.Empty;
                    php_port.Text = string.Empty;
                    Killprocess("Yi_php");
                    Invoke(new Action(() => BPThread(Sel.App.Php, Sel.Action.Stop)));
                    break;
                case Sel.Action.Error:
                    BtnPhpMode = Sel.Action.Start;
                    php_action_start.Text = Lp.Get("tab_console_action_start");
                    php_control_status.Text = Lp.Get("tab_console_status_nostart");
                    php_pid.Text = string.Empty;
                    php_port.Text = string.Empty;
                    Invoke(new Action(() => BPThread(Sel.App.Php, Sel.Action.Stop)));
                    break;
                case Sel.Action.OnStandby:
                    BtnPhpMode = Sel.Action.Start;
                    break;
                case Sel.Action.NoInst:
                    BtnPhpMode = Sel.Action.NoInst;
                    Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
                    break;
            }
        }

        #region PHP
        public void Start_php()
        {
            #region Check Skip
            if ((string)Cfg.Php.GetValue("isSkip") == null)
            {
                Cfg.Php.SetValue("isSkip", "Off");
            }
            else
            {
                if ((string)Cfg.Php.GetValue("isSkip") != "On" &&
                    (string)Cfg.Php.GetValue("isSkip") != "Off")
                {
                    Cfg.Php.SetValue("isSkip", "Off");
                }
            }
            #endregion

            switch ((string)Cfg.Php.GetValue("isSkip"))
            {
                case "On":
                    Msg(Sel.Type.Runtime, Lp.Get("Msg_been_installation_Skip") + "Visual C++ Redistributable for Visual Studio 2019");
                    break;
                case "Off":
                    if (VC.Package.IsInstalled(VC.Version.VC2015to2019x86))
                    {
                        Msg(Sel.Type.Runtime, Lp.Get("Msg_been_installation") + "Visual C++ Redistributable for Visual Studio 2019");
                    }
                    else
                    {
                        if (File.Exists(Cfg.MD + "\\php\\vcredist_x86.exe") &&
                            File.Exists(Cfg.MD + "\\php\\vcredist_x64.exe") &&
                            File.Exists(Cfg.MD + "\\php\\VisualCppRedist_AIO_x86_x64.exe"))
                        {
                            Msg(Sel.Type.Runtime, Lp.Get("Msg_Local_installation") + " Microsoft Visual C++ Redistributable for Visual Studio 2019");
                            ProcessStartInfo App_vcredist = new ProcessStartInfo
                            {
                                FileName = Cfg.MD + "\\php\\vcredist_x86.exe",
                                Arguments = "/install /passive /norestart"
                            };
                            Process App_vcredistp;
                            App_vcredistp = System.Diagnostics.Process.Start(App_vcredist);
                            if (App_vcredistp != null)
                                App_vcredistp.WaitForExit();
                        }
                        else
                        {
                            Runtime _AIO = new Runtime(this, VC.Version.VC2015to2019x86);
                            _AIO.ShowDialog();
                            return;
                        }
                    }
                    break;
            }

            BtnPhpMode = Sel.Action.Stop;
            Killprocess("Yi_php");
            php_action_start.Text = Lp.Get("tab_console_action_stop");
            php_control_status.Text = Lp.Get("tab_console_status_running");
            php_port.Text = (string)Cfg.Php.GetValue("php_port");

            if (Cfg.install_php)
            {
                var p = new Process();
                p.StartInfo.FileName = Cfg.Pphp;
                p.StartInfo.Arguments = "-b 127.0.0.1:" + (string)Cfg.Php.GetValue("php_port") + " - c php\\php.ini";
                p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
                Cfg.status_php = p.Start();
                try
                {
                    Cfg.Php.SetValue("php_procId", p.Id, RegistryValueKind.DWord);
                    php_pid.Text = p.Id.ToString();
                    php_port.Text = (string)Cfg.Php.GetValue("php_port");
                    php_action_start.Text = Lp.Get("tab_console_action_stop");
                    php_control_status.Text = Lp.Get("tab_console_status_running");
                    BtnPhpMode = Sel.Action.Stop;
                    Invoke(new Action(() => BPThread(Sel.App.Php, Sel.Action.Start)));
                    Msg(Sel.Type.Php, Lp.Get("tab_console_status_started"));
                }
                catch
                {
                    php_action_start.Text = Lp.Get("tab_console_action_start");
                    php_control_status.Text = Lp.Get("tab_console_status_nostart");
                    BtnPhpMode = Sel.Action.Start;
                    Msg(Sel.Type.Php, Lp.Get("Msg_Startup_failed"));
                }
            }
            else
            {
                BtnPhpMode = Sel.Action.NoInst;
                php_action_start.Text = Lp.Get("tab_console_action_start");
                php_control_status.Text = Lp.Get("tab_console_status_nostart");
                Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
            }
        }
        #endregion


        private void Php_action_admin_Click(object sender, EventArgs e)
        {
            if (Cfg.install_php)
            {
                var path = Cfg.MD + "\\php\\php.exe";
                GlobalOpenFile(path);
            }
            else
            {
                Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
            }
        }

        private void Php_action_config_Click(object sender, EventArgs e)
        {
            if (Cfg.install_php)
            {
                menu_php.Show(Cursor.Position);
            }
            else
            {
                Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
            }
        }

        private void Mysql_action_logs_Click(object sender, EventArgs e)
        {
            if (Cfg.install_mysql)
            {
                menu_mysql_logs.Show(Cursor.Position);
            }
            else
            {
                Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
            }
        }
        #endregion

        #region 动作 mysql
        private void Mysql_action_start_Click(object sender, EventArgs e)
        {
            switch (BtnMySqlMode)
            {
                case Sel.Action.Start:
                    Mysql_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.Stop:
                    Mysql_action_start_ext(Sel.Action.Stop);
                    break;
                case Sel.Action.Error:
                    Mysql_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.OnStandby:
                    Mysql_action_start_ext(Sel.Action.Start);
                    break;
                case Sel.Action.NoInst:
                    Mysql_action_start_ext(Sel.Action.NoInst);
                    break;
            }
        }

        public void Mysql_action_start_ext(Sel.Action mode)
        {
            switch (mode)
            {
                case Sel.Action.Start:
                    Start_mysql();
                    break;
                case Sel.Action.Stop:
                    BtnMySqlMode = Sel.Action.Start;
                    mysql_action_start.Text = Lp.Get("tab_console_action_start");
                    mysql_control_status.Text = Lp.Get("tab_console_status_nostart");
                    mysql_pid.Text = string.Empty;
                    mysql_port.Text = string.Empty;
                    Killprocess("Yi_mysqld");
                    Invoke(new Action(() => BPThread(Sel.App.MySql, Sel.Action.Stop)));
                    break;
                case Sel.Action.Error:
                    BtnMySqlMode = Sel.Action.Start;
                    mysql_action_start.Text = Lp.Get("tab_console_action_start");
                    mysql_control_status.Text = Lp.Get("tab_console_status_nostart");
                    mysql_pid.Text = string.Empty;
                    mysql_port.Text = string.Empty;
                    Invoke(new Action(() => BPThread(Sel.App.MySql, Sel.Action.Stop)));
                    break;
                case Sel.Action.OnStandby:
                    BtnPhpMode = Sel.Action.Start;
                    break;
                case Sel.Action.NoInst:
                    BtnMySqlMode = Sel.Action.NoInst;
                    Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
                    break;
            }
        }

        #region MySql
        public void Start_mysql()
        {
            BtnMySqlMode = Sel.Action.Stop;
            mysql_action_start.Text = Lp.Get("tab_console_action_stop");
            mysql_control_status.Text = Lp.Get("tab_console_status_running");
            Mysql_get_port();
            Killprocess("Yi_mysqld");

            if (File.Exists(Cfg.myini))
            {
                IniFile ini_file;
                ini_file = new IniFile();
                ini_file.Load(Cfg.myini);
                ini_file.SetKeyValue("mysqld", "datadir", Application.StartupPath.Replace("\\", @"/") + "/mysql/data");
                ini_file.SetKeyValue("mysqld", "port", "3306");
                ini_file.SetKeyValue("client", "plugin-dir", Application.StartupPath.Replace("\\", @"/") + "/mysql/lib/plugin");
                ini_file.SetKeyValue("client", "port", "3306");
                ini_file.Save(Cfg.myini);
                Msg(Sel.Type.MySql, "my.ini" + " " + Lp.Get("Msg_sync_config"));
            }
            else
            {
                BtnMySqlMode = Sel.Action.Start;
                Msg(Sel.Type.MySql, "my.ini" + " " + Lp.Get("Msg_no_sync_config"));
                return;
            }

            if (Cfg.install_mysql)
            {
                var p = new Process();
                p.StartInfo.FileName = Cfg.Pmysql;
                p.StartInfo.Arguments = "--defaults-file=" + Cfg.MD + "\\mysql\\data\\my.ini" + " --standalone --console";
                p.StartInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
                Cfg.status_mysql = p.Start();
                try
                {
                    Cfg.MySQL.SetValue("mysql_procId", p.Id, RegistryValueKind.DWord);
                    mysql_pid.Text = p.Id.ToString();
                    mysql_port.Text = (string)Cfg.MySQL.GetValue("mysql_port");
                    Mysql_get_port();
                    mysql_action_start.Text = Lp.Get("tab_console_action_stop");
                    mysql_control_status.Text = Lp.Get("tab_console_status_running");
                    BtnMySqlMode = Sel.Action.Stop;
                    Msg(Sel.Type.MySql, Lp.Get("tab_console_status_started"));
                    Invoke(new Action(() => BPThread(Sel.App.MySql, Sel.Action.Start)));
                }
                catch
                {
                    mysql_action_start.Text = Lp.Get("tab_console_action_start");
                    mysql_control_status.Text = Lp.Get("tab_console_status_nostart");
                    BtnMySqlMode = Sel.Action.Start;
                    Msg(Sel.Type.MySql, Lp.Get("Msg_Startup_failed"));
                }
            }
            else
            {
                mysql_action_start.Text = Lp.Get("tab_console_action_start");
                mysql_control_status.Text = Lp.Get("tab_console_status_nostart");
                BtnMySqlMode = Sel.Action.NoInst;
                Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
            }
        }
        #endregion

        private void Mysql_action_admin_Click(object sender, EventArgs e)
        {
            switch (BtnMySqlMode)
            {
                case Sel.Action.Start:
                    Msg(Sel.Type.MySql, Lp.Get("Msg_no_start_admin"));
                    break;
                case Sel.Action.Stop:
                    switch (BtnNginxMode)
                    {
                        case Sel.Action.Start:
                            Msg(Sel.Type.Nginx, Lp.Get("Msg_no_start_admin"));
                            break;
                        case Sel.Action.Stop:
                            switch (BtnPhpMode)
                            {
                                case Sel.Action.Start:
                                    Msg(Sel.Type.Php, Lp.Get("Msg_no_start_admin"));
                                    break;
                                case Sel.Action.Stop:
                                    GlobalBrowser("http://127.0.0.1/phpmyadmin");
                                    break;
                                case Sel.Action.Error:
                                    Msg(Sel.Type.Php, Lp.Get("Msg_no_start_admin"));
                                    break;
                                case Sel.Action.OnStandby:
                                    Msg(Sel.Type.Php, Lp.Get("Msg_no_start_admin"));
                                    break;
                                case Sel.Action.NoInst:
                                    Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
                                    break;
                            }
                            break;
                        case Sel.Action.Error:
                            Msg(Sel.Type.Nginx, Lp.Get("Msg_no_start_admin"));
                            break;
                        case Sel.Action.OnStandby:
                            Msg(Sel.Type.Nginx, Lp.Get("Msg_no_start_admin"));
                            break;
                        case Sel.Action.NoInst:
                            Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
                            break;
                    }
                    break;
                case Sel.Action.Error:
                    Msg(Sel.Type.MySql, Lp.Get("Msg_no_start_admin"));
                    break;
                case Sel.Action.OnStandby:
                    Msg(Sel.Type.MySql, Lp.Get("Msg_no_start_admin"));
                    break;
                case Sel.Action.NoInst:
                    Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
                    break;
            }
        }

        private void Mysql_action_config_Click(object sender, EventArgs e)
        {
            if (Cfg.install_mysql)
            {
                menu_mysql.Show(Cursor.Position);
            }
            else
            {
                Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
            }
        }

        private void Php_action_logs_Click(object sender, EventArgs e)
        {
            if (Cfg.install_php)
            {
                menu_php_logs.Show(Cursor.Position);
            }
            else
            {
                Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
            }
        }

        private void Menu_php_logs_errors_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\php\\logs\\php_errors.log";
            GlobalOpenFile(path);
        }

        private void Menu_php_logs_browser_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.MD + "\\php\\logs");
        }

        #region 菜单按钮
        private void Menu_mysql_port_Click(object sender, EventArgs e)
        {
            Port _Port = new Port(this, Sel.Type.MySql);
            _Port.ShowDialog();
        }

        private void Menu_mysql_my_ini_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\mysql\\data\\my.ini";
            GlobalOpenFile(path);
        }

        private void Menu_phpmyadmin_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\nginx\\html\\phpmyadmin\\config.inc.php";
            GlobalOpenFile(path);
        }

        private void Menu_mysql_browser_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.MD + "\\mysql");
        }

        private void Menu_phpmyadmin_browsr_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.MD + "\\nginx\\html\\phpmyadmin");
        }

        private void Menu_mysql_error_logs_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\mysql\\data\\mysql_error.log";
            GlobalOpenFile(path);
        }

        private void Menu_mysql_logs_browser_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.MD + "\\mysql\\data");
        }
        #endregion

        #region 获取 mysql 端口
        public void Mysql_get_port()
        {
            var myini = Cfg.MD + "\\mysql\\data\\my.ini";
            if (File.Exists(myini))
            {
                Msg(Sel.Type.MySql, Lp.Get("Msg_get_mysql_port") + " [ " + myini + " ]");
                IniFile ini_file;
                ini_file = new IniFile();
                ini_file.Load(myini);
                var port = ini_file.GetKeyValue("mysqld", "port");
                mysql_port.Text = port;
            }
            else
            {
                mysql_port.Text = string.Empty;
                Msg(Sel.Type.MySql, Lp.Get("Msg_no_mysql_config_file") + " [ " + myini + " ]");
            }
        }
        #endregion
        #endregion
        #endregion

        private void Change_editor_Click(object sender, EventArgs e)
        {
            menu_editor.Show(Cursor.Position);
        }

        private void Menu_editor_select_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog openFileDialog = new OpenFileDialog())
            {
                openFileDialog.Filter = "Application|*.exe";

                if (openFileDialog.ShowDialog() == DialogResult.OK)
                {
                    change_editor_name.Text = openFileDialog.FileName;
                    Cfg.UI.SetValue("editor", openFileDialog.FileName);
                }
            }
        }

        private void Menu_editor_Clear_Click(object sender, EventArgs e)
        {
            if ((string)Cfg.UI.GetValue("editor") != null)
            {
                Msg(Sel.Type.Editor, Lp.Get("already_reset"));
                change_editor_name.Text = string.Empty;
                Cfg.UI.DeleteValue("editor");
            }
            else
            {
                Msg(Sel.Type.Editor, Lp.Get("no_reset"));
            }
        }

        private void Change_browser_Click(object sender, EventArgs e)
        {
            menu_browser.Show(Cursor.Position);
        }

        private void Menu_browser_select_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog openFileDialog = new OpenFileDialog())
            {
                openFileDialog.Filter = "Application|*.exe";

                if (openFileDialog.ShowDialog() == DialogResult.OK)
                {
                    change_editor_browser.Text = openFileDialog.FileName;
                    Cfg.UI.SetValue("browser", openFileDialog.FileName);
                }
            }
        }

        private void Menu_browser_clear_Click(object sender, EventArgs e)
        {
            if ((string)Cfg.UI.GetValue("browser") != null)
            {
                Msg(Sel.Type.Browser, Lp.Get("already_reset"));
                change_editor_browser.Text = string.Empty;
                Cfg.UI.DeleteValue("browser");
            }
            else
            {
                Msg(Sel.Type.Browser, Lp.Get("no_reset"));
            }
        }

        #region 菜单按钮
        private void Menu_php_port_Click(object sender, EventArgs e)
        {
            Port _Port = new Port(this, Sel.Type.Php);
            _Port.ShowDialog();
        }

        private void Menu_php_ini_Click(object sender, EventArgs e)
        {
            var path = Cfg.MD + "\\php\\php.ini";
            GlobalOpenFile(path);
        }

        private void Menu_php_browser_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.MD + "\\php");
        }

        public void GlobalOpenFile(string path)
        {
            if ((string)Cfg.UI.GetValue("editor") == null)
            {
                if (File.Exists(path))
                {
                    System.Diagnostics.Process.Start("explorer.exe", path);
                    Msg(Sel.Type.Editor, Lp.Get("Msg_openfile_done") + " " + path);
                }
                else
                {
                    Msg(Sel.Type.Editor, Lp.Get("Msg_openfile_error") + " " + path);
                }
            }
            else
            {
                if (File.Exists((string)Cfg.UI.GetValue("editor")))
                {
                    if (File.Exists(path))
                    {
                        System.Diagnostics.ProcessStartInfo Info = new System.Diagnostics.ProcessStartInfo
                        {
                            FileName = (string)Cfg.UI.GetValue("editor"),
                            Arguments = path
                        };
                        System.Diagnostics.Process.Start(Info);
                        Msg(Sel.Type.Editor, Lp.Get("Msg_openfile_done") + " " + path);
                    }
                    else
                    {
                        Msg(Sel.Type.Editor, Lp.Get("Msg_openfile_error") + " " + path);
                    }
                }
                else
                {
                    System.Diagnostics.Process.Start("explorer.exe", path);
                    Msg(Sel.Type.Editor, Lp.Get("Msg_custom_edition_open_error") + " " + path);
                }
            }
        }
        #endregion

        public void GlobalBrowser(string url)
        {
            if ((string)Cfg.UI.GetValue("browser") == null)
            {
                System.Diagnostics.Process.Start(url);
                Msg(Sel.Type.Browser, Lp.Get("Msg_default_browser_open") + " " + url);
            }
            else
            {
                if (File.Exists((string)Cfg.UI.GetValue("browser")))
                {
                    System.Diagnostics.ProcessStartInfo Info = new System.Diagnostics.ProcessStartInfo
                    {
                        FileName = (string)Cfg.UI.GetValue("browser"),
                        Arguments = url
                    };
                    System.Diagnostics.Process.Start(Info);
                    Msg(Sel.Type.Browser, Lp.Get("Msg_custom_browser_open") + " " + url);
                }
                else
                {
                    System.Diagnostics.Process.Start(url);
                    Msg(Sel.Type.Browser, Lp.Get("Msg_custom_edition_open_error") + " " + url);
                }
            }
        }

        public void OpenFolder(string path)
        {
            if (Directory.Exists(path))
            {
                System.Diagnostics.Process.Start("explorer.exe", path);
                Msg(Sel.Type.Action, Lp.Get("Msg_open_folder") + " " + path);
            }
            else
            {
                Msg(Sel.Type.Action, Lp.Get("Msg_open_folder_not") + " " + path);
            }
        }

        private void Lp_English_flat_Click(object sender, EventArgs e)
        {
            Lp.SetLanguage("en-US");
            Invoke(new Action(() => SetLanguage()));
        }

        private void English_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Lp.SetLanguage("en-US");
            Invoke(new Action(() => SetLanguage()));
        }
        private void Lp_Chinese_flat_Click(object sender, EventArgs e)
        {
            Lp.SetLanguage("zh-CN");
            Invoke(new Action(() => SetLanguage()));
        }

        private void Chinese_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Lp.SetLanguage("zh-CN");
            Invoke(new Action(() => SetLanguage()));
        }

        private void Lp_zh_TW_flat_Click(object sender, EventArgs e)
        {
            Lp.SetLanguage("zh-TW");
            Invoke(new Action(() => SetLanguage()));
        }

        private void Lp_zh_TW_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Lp.SetLanguage("zh-TW");
            Invoke(new Action(() => SetLanguage()));
        }

        private void Lp_ko_KR_flat_Click(object sender, EventArgs e)
        {
            Lp.SetLanguage("ko-KR");
            Invoke(new Action(() => SetLanguage()));
        }


        private void Lp_ko_KR_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Lp.SetLanguage("ko-KR");
            Invoke(new Action(() => SetLanguage()));
        }

        private void Set_dark_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            if (IsUseTheme.Checked)
            {
                setting_theme_msg_ok.AccessibleDescription = Sel.Style.Dark.ToString();
                setting_theme_msg.Visible = true;
            }
            else
            {
                if ((string)Cfg.UI.GetValue("isDark") != "Dark")
                {
                    Msg(Sel.Type.Setting, Lp.Get("Color_Choose") + " " + Lp.Get("Color_Choose_Dark"));
                    Skin.SetThemes(Sel.Style.Dark, this);
                    Invoke(new Action(() => Dark()));
                }
                else
                {
                    Msg(Sel.Type.Setting, Lp.Get("IsUseTheme_same") + " " + Lp.Get("Color_Choose_Dark"));
                }
            }
        }

        private void Set_light_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            if (IsUseTheme.Checked)
            {
                setting_theme_msg_ok.AccessibleDescription = Sel.Style.Light.ToString();
                setting_theme_msg.Visible = true;
            }
            else
            {
                if ((string)Cfg.UI.GetValue("isDark") != "Light")
                {
                    Msg(Sel.Type.Setting, Lp.Get("Color_Choose") + " " + Lp.Get("Color_Choose_Light"));
                    Skin.SetThemes(Sel.Style.Light, this);
                    Invoke(new Action(() => Dark()));
                }
                else
                {
                    Msg(Sel.Type.Setting, Lp.Get("IsUseTheme_same") + " " + Lp.Get("Color_Choose_Light"));
                }
            }
        }

        private void Setting_theme_msg_ok_Click(object sender, EventArgs e)
        {
            switch (setting_theme_msg_ok.AccessibleDescription)
            {
                case "Dark":
                    if ((string)Cfg.UI.GetValue("isDark") != "Dark")
                    {
                        Skin.SetThemes(Sel.Style.Dark, this);
                        Msg(Sel.Type.Setting, Lp.Get("Color_Choose") + " " + Lp.Get("Color_Choose_Dark"));
                    }
                    else
                    {
                        Msg(Sel.Type.Setting, Lp.Get("IsUseTheme_same") + " " + Lp.Get("Color_Choose_Dark"));
                    }
                    break;
                case "Light":
                    if ((string)Cfg.UI.GetValue("isDark") != "Light")
                    {
                        Skin.SetThemes(Sel.Style.Light, this);
                        Msg(Sel.Type.Setting, Lp.Get("Color_Choose") + " " + Lp.Get("Color_Choose_Light"));
                    }
                    else
                    {
                        Msg(Sel.Type.Setting, Lp.Get("IsUseTheme_same") + " " + Lp.Get("Color_Choose_Light"));
                    }
                    break;
            }
            Invoke(new Action(() => Dark()));
            IsUseTheme.Checked = false;
            setting_theme_msg.Visible = false;
        }

        private void Setting_theme_msg_canel_Click(object sender, EventArgs e)
        {
            setting_theme_msg.Visible = false;
        }

        private void IsUseTheme_CheckedChanged(object sender, EventArgs e)
        {
            if (IsUseTheme.Checked)
            {
                IsUserThemeChange(Sel.Action.On);
            }
            else
            {
                IsUserThemeChange(Sel.Action.Off);
            }
        }

        private void IsUserThemeChange(Sel.Action active)
        {
            switch (active)
            {
                case Sel.Action.On:
                    Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("IsUseTheme"));
                    Cfg.UI.SetValue("isDark_dynamic", "On");
                    ThreadDark(Sel.Action.Stop);
                    ThreadDark(Sel.Action.Start);
                    break;
                case Sel.Action.Off:
                    Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("IsUseTheme"));
                    Cfg.UI.SetValue("isDark_dynamic", "Off");
                    ThreadDark(Sel.Action.Stop);
                    break;
            }
        }

        #region Page Function 1 to 3
        private void Select_page_1_Click(object sender, EventArgs e)
        {
            Page_1.Visible = true;
            Page_2.Visible = false;
            Page_3.Visible = false;
            lp_change_view.Visible = false;
        }

        private void Select_page_2_Click(object sender, EventArgs e)
        {
            Page_1.Visible = false;
            Page_2.Visible = true;
            Page_3.Visible = false;
            lp_change_view.Visible = false;
        }

        private void Select_page_3_Click(object sender, EventArgs e)
        {
            Page_1.Visible = false;
            Page_2.Visible = false;
            Page_3.Visible = true;
            lp_change_view.Visible = false;
        }
        #endregion

        #region menu log
        private void Menu_log_copy_Click(object sender, EventArgs e)
        {
            if (MsgInfo.Text != null && MsgInfo.Text != "")
                Clipboard.SetText(MsgInfo.Text, TextDataFormat.UnicodeText);
        }

        private void Menu_log_clear_Click(object sender, EventArgs e)
        {
            MsgInfo.Clear();
        }

        private void Menu_log_copy_selectd_Click(object sender, EventArgs e)
        {
            if (MsgInfo.SelectedText != null && MsgInfo.SelectedText != "")
                Clipboard.SetText(MsgInfo.SelectedText.Replace("\n", "\r\n"));
        }
        #endregion

        private void Author_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            GlobalBrowser("http://fengyi.tel");
        }

        private void Tab_console_auto_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            menu_auto_ext.Show(Cursor.Position);
        }

        private void Menu_auto_ext_all_Click(object sender, EventArgs e)
        {
            Start_App_MySql.Checked = true;
            Start_App_Php.Checked = true;
            Start_App_Nginx.Checked = true;
        }

        private void IsSave_Local_CheckedChanged(object sender, EventArgs e)
        {
            if (isSave_Local.Checked)
            {
                Cfg.Log.SetValue("isSave_Local", "On");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("isSave_Local"));
            }
            else
            {
                Cfg.Log.SetValue("isSave_Local", "Off");
                Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("isSave_Local"));
            }
        }

        private void IsLog_Time_left_CheckedChanged(object sender, EventArgs e)
        {
            if (isLog_Time_left.Checked)
            {
                Cfg.Log.SetValue("isSave_log", "On");
                isLog_Time.Enabled = true;
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("save_day_left") + " " + Lp.Get("save_day_right"));
            }
            else
            {
                Cfg.Log.SetValue("isSave_log", "Off");
                isLog_Time.Enabled = false;
                Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("save_day_left") + " " + Lp.Get("save_day_right"));
            }
        }


        private void Save_day_ValueChanged(object sender, EventArgs e)
        {
            Cfg.Log.SetValue("isLog_Time", isLog_Time.Value, RegistryValueKind.DWord);
        }

        private void Save_day_open_Click(object sender, EventArgs e)
        {
            var path = Cfg.RoamingPath + "\\logs\\" + Cfg.Log.GetValue("Name") + ".log";
            GlobalOpenFile(path);
        }

        private void Save_day_browser_Click(object sender, EventArgs e)
        {
            OpenFolder(Cfg.RoamingPath + "\\logs");
        }

        private void Lp_sync_Click(object sender, EventArgs e)
        {
            ExtShowLP();
        }

        private void Lp_dynamic_text_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            ExtShowLP();
        }

        void ExtShowLP()
        {
            Page_1.Visible = false;
            Page_2.Visible = false;
            Page_3.Visible = false;
            lp_change_view.Visible = true;
        }

        private void Msg_been_installation_Skip_CheckedChanged(object sender, EventArgs e)
        {
            if (isSkip.Checked)
            {
                Cfg.Php.SetValue("isSkip", "On");
                Msg(Sel.Type.Setting, Lp.Get("Msg_chosen") + " " + Lp.Get("Msg_been_installation_Skip"));
            }
            else
            {
                Cfg.Php.SetValue("isSkip", "Off");
                Msg(Sel.Type.Setting, Lp.Get("Msg_cancel") + " " + Lp.Get("Msg_been_installation_Skip"));
            }
        }

        private void Menu_auto_ext_clear_Click(object sender, EventArgs e)
        {
            Start_App_MySql.Checked = false;
            Start_App_Php.Checked = false;
            Start_App_Nginx.Checked = false;
        }

        private void Menu_select_ext_all_kill_Click(object sender, EventArgs e)
        {
            if (Cfg.install_nginx)
            {
                Killprocess("Yi_nginx");
                Invoke(new Action(() => BPThread(Sel.App.Nginx, Sel.Action.Stop)));
                nginx_pid.Text = string.Empty;
                nginx_port.Text = string.Empty;
                nginx_action_start.Text = Lp.Get("tab_console_action_start");
                nginx_control_status.Text = Lp.Get("tab_console_status_nostart");
                BtnNginxMode = Sel.Action.Start;
            }
            else
            {
                Msg(Sel.Type.Nginx, Lp.Get("Msg_no_install_app"));
            }

            if (Cfg.install_php)
            {
                Killprocess("Yi_php");
                Invoke(new Action(() => BPThread(Sel.App.Php, Sel.Action.Stop)));
                php_pid.Text = string.Empty;
                php_port.Text = string.Empty;
                php_action_start.Text = Lp.Get("tab_console_action_start");
                php_control_status.Text = Lp.Get("tab_console_status_nostart");
                BtnPhpMode = Sel.Action.Stop;
            }
            else
            {
                Msg(Sel.Type.Php, Lp.Get("Msg_no_install_app"));
            }

            if (Cfg.install_mysql)
            {
                Killprocess("Yi_mysqld");
                Invoke(new Action(() => BPThread(Sel.App.MySql, Sel.Action.Stop)));
                mysql_pid.Text = string.Empty;
                mysql_port.Text = string.Empty;
                mysql_action_start.Text = Lp.Get("tab_console_action_start");
                mysql_control_status.Text = Lp.Get("tab_console_status_nostart");
                BtnMySqlMode = Sel.Action.Start;
            }
            else
            {
                Msg(Sel.Type.MySql, Lp.Get("Msg_no_install_app"));
            }
        }

        public void BPThread(Sel.App page, Sel.Action mode)
        {
            switch (page)
            {
                case Sel.App.Nginx:
                    switch (mode)
                    {
                        case Sel.Action.Start:
                            thread_nginx = new BPT(this);
                            BPT.thread_nginx = new Thread(new ThreadStart(thread_nginx.Nginx))
                            {
                                IsBackground = true
                            };
                            BPT.thread_nginx.Start();
                            break;
                        case Sel.Action.Stop:
                            if (BPT.thread_nginx != null)
                                BPT.thread_nginx.Abort();
                            break;
                    }
                    break;
                case Sel.App.Php:
                    switch (mode)
                    {
                        case Sel.Action.Start:
                            thread_php = new BPT(this);
                            BPT.thread_php = new Thread(new ThreadStart(thread_php.Php))
                            {
                                IsBackground = true
                            };
                            BPT.thread_php.Start();
                            break;
                        case Sel.Action.Stop:
                            if (BPT.thread_php != null)
                                BPT.thread_php.Abort();
                            break;
                    }
                    break;
                case Sel.App.MySql:
                    switch (mode)
                    {
                        case Sel.Action.Start:
                            thread_mysql = new BPT(this);
                            BPT.thread_mysql = new Thread(new ThreadStart(thread_mysql.MySql))
                            {
                                IsBackground = true
                            };
                            BPT.thread_mysql.Start();
                            break;
                        case Sel.Action.Stop:
                            if (BPT.thread_mysql != null)
                                BPT.thread_mysql.Abort();
                            break;
                    }
                    break;
            }
        }

        public void ThreadDark(Sel.Action mode)
        {
            switch (mode)
            {
                case Sel.Action.Start:
                    thread_DarkCheck = new Skin(this);
                    Skin.thread_DarkCheck = new Thread(new ThreadStart(thread_DarkCheck.Run))
                    {
                        IsBackground = true
                    };
                    Skin.thread_DarkCheck.Start();
                    break;
                case Sel.Action.Stop:
                    if (Skin.thread_DarkCheck != null)
                        Skin.thread_DarkCheck.Abort();
                    break;
            }
        }
    }
}