﻿using System;
using System.Windows.Forms;

namespace WNMP
{
    public partial class Runtime : Form
    {
        public readonly MainInterface main;
        readonly VC.Version ChkVer;
        public string Dlx86link, Dlx64link, Dlx86page, Dlx64page, DlName;

        public Runtime(MainInterface m, VC.Version Ver)
        {
            InitializeComponent();
            main = m;
            ChkVer = Ver;
        }

        private void Dark()
        {
            switch ((string)Cfg.UI.GetValue("isDark"))
            {
                case "Dark":
                    this.Icon = global::WNMP.Properties.Resources.Yi_white;
                    HIPS.Image = global::WNMP.Properties.Resources.hips_dark;
                    DL_1.Image = global::WNMP.Properties.Resources.dl_dark;
                    DL_2.Image = global::WNMP.Properties.Resources.dl_dark;
                    DL_3.Image = global::WNMP.Properties.Resources.dl_dark;
                    DL_4.Image = global::WNMP.Properties.Resources.dl_dark;
                    DL_5.Image = global::WNMP.Properties.Resources.dl_dark;
                    break;
                case "Light":
                    this.Icon = global::WNMP.Properties.Resources.Yi;
                    HIPS.Image = global::WNMP.Properties.Resources.hips;
                    DL_1.Image = global::WNMP.Properties.Resources.dl;
                    DL_2.Image = global::WNMP.Properties.Resources.dl;
                    DL_3.Image = global::WNMP.Properties.Resources.dl;
                    DL_4.Image = global::WNMP.Properties.Resources.dl;
                    DL_5.Image = global::WNMP.Properties.Resources.dl;
                    break;
            }
            Skin.ChangeControl(this);
        }

        private void ShowDialog_Load(object sender, EventArgs e)
        {
            Version(ChkVer);
            Dark();

            switch ((string)Cfg.Php.GetValue("isSkip"))
            {
                case "On":
                    isSkip.Checked = true;
                    break;
                case "Off":
                    isSkip.Checked = false;
                    break;
            }

            Msg_Title.Text = Lp.Get("Msg_no_runtime");
            title_ver.Text = DlName;

            Msg_Runtime_Od.Text = Lp.Get("Msg_Runtime_Od");
            Title_OD.Text = Lp.Get("Msg_Runtime_OD");
            Title_OD_Link.Text = Lp.Get("Msg_Runtime_DP");

            Msg_Runtime_TP.Text = Lp.Get("Msg_Runtime_TP");
            Dl_Tp_Link.Text = Lp.Get("Msg_Runtime_OD");
            Dl_Tp_Link_Page.Text = Lp.Get("Msg_Runtime_DP");
            Dl_jameszero_Link_Page.Text = Lp.Get("Msg_Runtime_DP");

            isSkip.Text = Lp.Get("Msg_been_installation_Skip");
            Close_Canel.Text = Lp.Get("cancel");
        }

        void Version(VC.Version aa)
        {
            switch (aa)
            {
                case VC.Version.VC2015to2019x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2015, 2017 and 2019";
                    Dlx86link = "https://aka.ms/vs/16/release/vc_redist.x86.exe";
                    Dlx64link = "https://aka.ms/vs/16/release/vc_redist.x64.exe";
                    Dlx86page = "https://fengyi.tel/go/get-dl-od-link-page";
                    Dlx64page = "https://fengyi.tel/go/get-dl-od-link-page";
                    break;
                case VC.Version.VC2015to2019x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2015, 2017 and 2019";
                    Dlx86link = "https://aka.ms/vs/16/release/vc_redist.x86.exe";
                    Dlx64link = "https://aka.ms/vs/16/release/vc_redist.x64.exe";
                    Dlx86page = "https://fengyi.tel/go/get-dl-od-link-page";
                    Dlx64page = "https://fengyi.tel/go/get-dl-od-link-page";
                    break;
                case VC.Version.VC2017x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2017";
                    Dlx86link = "https://go.microsoft.com/fwlink/?LinkId=746571";
                    Dlx64link = "https://go.microsoft.com/fwlink/?LinkId=746572";
                    Dlx86page = "https://go.microsoft.com/fwlink/?LinkId=746571";
                    Dlx64page = "https://go.microsoft.com/fwlink/?LinkId=746572";
                    break;
                case VC.Version.VC2017x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2017";
                    Dlx86link = "https://go.microsoft.com/fwlink/?LinkId=746571";
                    Dlx64link = "https://go.microsoft.com/fwlink/?LinkId=746572";
                    Dlx86page = "https://go.microsoft.com/fwlink/?LinkId=746571";
                    Dlx64page = "https://go.microsoft.com/fwlink/?LinkId=746572";
                    break;
                case VC.Version.VC2015x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2015";
                    Dlx86link = "https://download.microsoft.com/download/9/3/F/93FCF1E7-E6A4-478B-96E7-D4B285925B00/vc_redist.x86.exe";
                    Dlx64link = "https://download.microsoft.com/download/9/3/F/93FCF1E7-E6A4-478B-96E7-D4B285925B00/vc_redist.x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=48145";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=48145";
                    break;
                case VC.Version.VC2015x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2015";
                    Dlx86link = "https://download.microsoft.com/download/9/3/F/93FCF1E7-E6A4-478B-96E7-D4B285925B00/vc_redist.x86.exe";
                    Dlx64link = "https://download.microsoft.com/download/9/3/F/93FCF1E7-E6A4-478B-96E7-D4B285925B00/vc_redist.x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=48145";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=48145";
                    break;
                case VC.Version.VC2013x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2013";
                    Dlx86link = "http://download.microsoft.com/download/2/E/6/2E61CFA4-993B-4DD4-91DA-3737CD5CD6E3/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/2/E/6/2E61CFA4-993B-4DD4-91DA-3737CD5CD6E3/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=40784";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=40784";
                    break;
                case VC.Version.VC2013x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2013";
                    Dlx86link = "http://download.microsoft.com/download/2/E/6/2E61CFA4-993B-4DD4-91DA-3737CD5CD6E3/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/2/E/6/2E61CFA4-993B-4DD4-91DA-3737CD5CD6E3/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=40784";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=40784";
                    break;
                case VC.Version.VC2012x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2012";
                    Dlx86link = "http://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU3/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU3/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=30679";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=30679";
                    break;
                case VC.Version.VC2012x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2012";
                    Dlx86link = "http://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU3/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU3/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=30679";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=30679";
                    break;
                case VC.Version.VC2010x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2010";
                    Dlx86link = "http://download.microsoft.com/download/5/B/C/5BC5DBB3-652D-4DCE-B14A-475AB85EEF6E/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/3/2/2/3224B87F-CFA0-4E70-BDA3-3DE650EFEBA5/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=5555";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=5555";
                    break;
                case VC.Version.VC2010x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2010";
                    Dlx86link = "http://download.microsoft.com/download/5/B/C/5BC5DBB3-652D-4DCE-B14A-475AB85EEF6E/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/3/2/2/3224B87F-CFA0-4E70-BDA3-3DE650EFEBA5/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=5555";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=5555";
                    break;
                case VC.Version.VC2008x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2008";
                    Dlx86link = "http://download.microsoft.com/download/1/1/1/1116b75a-9ec3-481a-a3c8-1777b5381140/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/d/2/4/d242c3fb-da5a-4542-ad66-f9661d0a8d19/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=29";
                    Dlx64page = "https://www.microsoft.com/en-sg/download/details.aspx?id=15336";
                    break;
                case VC.Version.VC2008x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2008";
                    Dlx86link = "http://download.microsoft.com/download/1/1/1/1116b75a-9ec3-481a-a3c8-1777b5381140/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/d/2/4/d242c3fb-da5a-4542-ad66-f9661d0a8d19/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=29";
                    Dlx64page = "https://www.microsoft.com/en-sg/download/details.aspx?id=15336";
                    break;
                case VC.Version.VC2005x86:
                    DlName = "Visual C++ Redistributable for Visual Studio 2005";
                    Dlx86link = "http://download.microsoft.com/download/d/3/4/d342efa6-3266-4157-a2ec-5174867be706/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/9/1/4/914851c6-9141-443b-bdb4-8bad3a57bea9/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=26347";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=26347";
                    break;
                case VC.Version.VC2005x64:
                    DlName = "Visual C++ Redistributable for Visual Studio 2005";
                    Dlx86link = "http://download.microsoft.com/download/d/3/4/d342efa6-3266-4157-a2ec-5174867be706/vcredist_x86.exe";
                    Dlx64link = "http://download.microsoft.com/download/9/1/4/914851c6-9141-443b-bdb4-8bad3a57bea9/vcredist_x64.exe";
                    Dlx86page = "https://www.microsoft.com/en-us/download/details.aspx?id=26347";
                    Dlx64page = "https://www.microsoft.com/en-us/download/details.aspx?id=26347";
                    break;
            }
        }

        private void Close_Canel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void IsSkip_CheckedChanged(object sender, EventArgs e)
        {
            if (isSkip.Checked)
            {
                main.isSkip.Checked = true;
            }
            else
            {
                main.isSkip.Checked = false;
            }
        }

        private void Dl_Od_Link_x64_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            main.GlobalBrowser(Dlx64link);
        }

        private void Dl_Od_Link_x86_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            main.GlobalBrowser(Dlx86link);
        }

        private void Title_OD_Click(object sender, EventArgs e)
        {

        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            main.GlobalBrowser("https://jameszero.net/runtimepack.htm");
        }

        private void Dl_Od_Link_Page_x64_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            main.GlobalBrowser(Dlx64page);
        }

        private void Dl_Od_Link_Page_x86_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            main.GlobalBrowser(Dlx86page);
        }

        private void Dl_Tpd_Link_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            main.GlobalBrowser("https://fengyi.tel/go/get-dl-tp-link");
        }

        private void Dl_Tpd_Link_Page_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            main.GlobalBrowser("https://fengyi.tel/go/get-dl-tp-link-page");
        }
    }
}