﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace WNMP
{
    public partial class IsClose : Form
    {
        public readonly MainInterface main;

        public IsClose(MainInterface m)
        {
            InitializeComponent();
            main = m;
        }

        private void SetLanguage()
        {
            click_close_button.Text = Lp.Get("click_close_button");
            Close_Hide.Text = Lp.Get("tab_setting_Close_Hide");
            Close_Select_App_Exit.Text = Lp.Get("tab_setting_Close_Select_App_Exit");
            Close_All_App_Exit.Text = Lp.Get("tab_setting_Close_All_App_Exit");
            Close_Exit.Text = Lp.Get("tab_setting_Close_Exit");
            isPrompt.Text = Lp.Get("tab_setting_isPrompt");
            Close_Canel.Text = Lp.Get("cancel");
            OK.Text = Lp.Get("ok");
        }

        private void Dark()
        {
            switch ((string)Cfg.UI.GetValue("isDark"))
            {
                case "Dark":
                    this.Icon = global::WNMP.Properties.Resources.Yi_white;
                    HIPS.Image = global::WNMP.Properties.Resources.hips_dark;
                    break;
                case "Light":
                    this.Icon = global::WNMP.Properties.Resources.Yi;
                    HIPS.Image = global::WNMP.Properties.Resources.hips;
                    break;
            }
            Skin.ChangeControl(this);
        }

        private void MainClose_Load(object sender, EventArgs e)
        {
            SetLanguage();
            Dark();

            #region 关闭面板时
            switch ((string)Cfg.UI.GetValue("After_Closing"))
            {
                case "Hide":
                    Close_Hide.Checked = true;
                    break;
                case "Select":
                    Close_Select_App_Exit.Checked = true;
                    break;
                case "Exit":
                    Close_Exit.Checked = true;
                    break;
                case "ExitAll":
                    Close_All_App_Exit.Checked = true;
                    break;
            }

            switch ((string)Cfg.UI.GetValue("isPrompt"))
            {
                case "On":
                    isPrompt.Checked = true;
                    break;
                case "Off":
                    isPrompt.Checked = false;
                    break;
            }
            #endregion
        }

        private void OK_Click(object sender, EventArgs e)
        {
            if (Close_Hide.Checked)
            {
                main.PageStatus(true, 1);
            }

            if (Close_Select_App_Exit.Checked)
            {
                if (main.Start_App_Php.Checked)
                {
                    BPT.Killprocess("Yi_php");
                }
                if (main.Start_App_MySql.Checked)
                {
                    BPT.Killprocess("Yi_mysqld");
                }
                if (main.Start_App_Nginx.Checked)
                {
                    BPT.Killprocess("Yi_nginx");
                }

                Application.Exit();
            }

            if (Close_Exit.Checked)
            {
                Application.Exit();
            }

            if (Close_All_App_Exit.Checked)
            {
                BPT.Killprocess("Yi_php");
                BPT.Killprocess("Yi_mysqld");
                BPT.Killprocess("Yi_nginx");

                Application.Exit();
            }

            this.Close();
        }

        private void Close_Canel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Close_Hide_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Hide.Checked)
            {
                main.Close_Hide.Checked = true;
            }
            else
            {
                main.Close_Hide.Checked = false;
            }
        }

        private void Close_Select_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Select_App_Exit.Checked)
            {
                main.Close_Select_App_Exit.Checked = true;
            }
            else
            {
                main.Close_Select_App_Exit.Checked = false;
            }
        }

        private void Close_All_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_All_App_Exit.Checked)
            {
                main.Close_All_App_Exit.Checked = true;
            }
            else
            {
                main.Close_All_App_Exit.Checked = false;
            }
        }

        private void Close_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Exit.Checked)
            {
                main.Close_Exit.Checked = true;
            }
            else
            {
                main.Close_Exit.Checked = false;
            }
        }

        private void IsPrompt_CheckedChanged(object sender, EventArgs e)
        {
            if (isPrompt.Checked)
            {
                main.isPrompt.Checked = true;
            }
            else
            {
                main.isPrompt.Checked = false;
            }
        }
    }
}
