﻿using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Xml;

namespace WNMP
{
    class Lp
    {
        public static string Lang { get; set; }
        public static Dictionary<string, string> All_LP = new Dictionary<string, string>()
        {
            {"en-US", "en-US"},
            {"zh-CN", "zh-CN"},
            {"zh-TW", "zh-TW"},
            {"ko-KR", "ko-KR"}
        };

        public static Dictionary<string, string> lang = new Dictionary<string, string>();

        public static string Get(string title)
        {
            if (lang.TryGetValue(title, out string value))
            {
                return value;
            }
            else
            {
                return "No.";
            }
        }

        public static void Start()
        {
            if ((string)Cfg.UI.GetValue("lang") == null)
            {
                Cfg.UI.SetValue("lang", System.Globalization.CultureInfo.CurrentUICulture.Name);
            }
            SetLanguage((string)Cfg.UI.GetValue("lang"));
        }

        public static void SetLanguage(string newlang)
        {
            Cfg.UI.SetValue("lang", newlang);
            if (All_LP.TryGetValue(newlang, out string lp))
            {
                Lang = lp;
            }
            else
            {
                Lang = "en-US";
            }
            Extract();
            GetLanguage();
        }

        public static void Extract()
        {
            if (!File.Exists(Cfg.RoamingPath + "\\Languages\\" + Lang + ".xml"))
            {
                Extract("WNMP", Cfg.RoamingPath + "\\Languages", "Language", Lang + ".xml");
            }
        }

        public static void Extract(string nameSpace, string outDirectory, string internalFilePath, string resourceName)
        {
            Directory.CreateDirectory(outDirectory);
            Assembly assembly = Assembly.GetCallingAssembly();
            using (Stream s = assembly.GetManifestResourceStream(nameSpace + "." + (internalFilePath == "" ? "" : internalFilePath + ".") + resourceName))
            using (BinaryReader r = new BinaryReader(s))
            using (FileStream fs = new FileStream(outDirectory + "\\" + resourceName, FileMode.OpenOrCreate))
            using (BinaryWriter w = new BinaryWriter(fs))
            {
                w.Write(r.ReadBytes((int)s.Length));
            }
        }

        public static void GetLanguage()
        {
            lang.Clear();
            using (XmlReader reader = XmlReader.Create(Cfg.RoamingPath + "\\languages\\" + Lang + ".xml"))
            {
                while (reader.Read())
                {
                    if (reader.IsStartElement())
                    {
                        string attribute = reader["name"];
                        if (attribute != null)
                        {
                            if (reader.Read())
                            {
                                lang.Add(attribute, reader.Value.Trim());
                            }
                        }
                    }
                }
            }
        }
    }
}