﻿using Microsoft.Win32;
using System.Drawing;
using System.Threading;
using System.Windows.Forms;

namespace WNMP
{
    class Skin
    {
        readonly MainInterface main;
        public static Thread thread_DarkCheck;
        public static Color NBackColor { get; set; }
        public static Color NForeColor { get; set; }
        public static Color NNAColor { get; set; }
        public static Color NNBColor { get; set; }


        public Skin(MainInterface m)
        {
            main = m;
        }

        public static void Start()
        {
            if ((string)Cfg.UI.GetValue("isDark") == null)
            {
                Cfg.UI.SetValue("isDark", IsDark());
            }
            else
            {
                if ((string)Cfg.UI.GetValue("isDark") != "Light" &&
                    (string)Cfg.UI.GetValue("isDark") != "Dark")
                {
                   Cfg.UI.SetValue("isDark", "Light");
                }
            }

            if ((string)Cfg.UI.GetValue("isDark_dynamic") == null)
            {
                Cfg.UI.SetValue("isDark_dynamic", "Off");
            }
            else
            {
                if ((string)Cfg.UI.GetValue("isDark_dynamic") != "On" &&
                    (string)Cfg.UI.GetValue("isDark_dynamic") != "Off")
                {
                    Cfg.UI.SetValue("isDark_dynamic", "Off");
                }
            }
            SkinColor();
        }

        public static void SetThemes(Sel.Style newthemes, Control m)
        {
            switch (newthemes)
            {
                case Sel.Style.Dark:
                    Cfg.UI.SetValue("isDark", newthemes);
                    SkinColor();
                    ChangeControl(m);
                    break;
                case Sel.Style.Light:
                    Cfg.UI.SetValue("isDark", newthemes);
                    SkinColor();
                    ChangeControl(m);
                    break;
            }
        }

        public static void SkinColor()
        {
            switch ((string)Cfg.UI.GetValue("isDark"))
            {
                case "Dark":
                    NBackColor = Color.FromArgb(25, 25, 25);
                    NForeColor = Color.FromArgb(242, 242, 242);
                    NNAColor = Color.FromArgb(242, 242, 242);
                    NNBColor = Color.FromArgb(32, 32, 32);
                    break;
                case "Light":
                    NBackColor = Color.FromArgb(255, 255, 255);
                    NForeColor = Color.FromArgb(0, 0, 0);
                    NNAColor = Color.FromArgb(0, 0, 0);
                    NNBColor = Color.FromArgb(255, 255, 255);
                    break;
            }
        }

        public static void ChangeControl(Control Ct)
        {
            foreach (Control C in Ct.Controls)
            {
                Ct.ForeColor = NForeColor;
                Ct.BackColor = NBackColor;

                if (Ct.AccessibleName == "yi")
                {
                    Ct.ForeColor = NNAColor;
                    Ct.BackColor = NNBColor;
                }

                if (C.HasChildren)
                {
                    C.ForeColor = NForeColor;
                    C.BackColor = NBackColor;

                    if (C.AccessibleName == "yi")
                    {
                        C.ForeColor = NNAColor;
                        C.BackColor = NNBColor;
                    }
                    ChangeControl(C);
                }

                if (C is RichTextBox)
                {
                    if (C.AccessibleName == "yi")
                    {
                        (C as RichTextBox).ForeColor = NNAColor;
                        (C as RichTextBox).BackColor = NNBColor;
                    }
                }

                if (C is LinkLabel)
                {
                    (C as LinkLabel).ActiveLinkColor = NForeColor;
                    (C as LinkLabel).LinkColor = NForeColor;
                }
            }
        }

        public static string IsDark()
        {
            using (RegistryKey key = Registry.CurrentUser.OpenSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize"))
            {
                object registryValueObject = key?.GetValue("AppsUseLightTheme");
                if (registryValueObject == null)
                {
                    return "Light";
                }
                int registryValue = (int)registryValueObject;
                return registryValue > 0 ? "Light" : "Dark";
            }
        }

        public void Run()
        {
            while (true)
            {
                switch (IsDark())
                {
                    case "Dark":
                        if ((string)Cfg.UI.GetValue("isDark") != "Dark")
                        {
                            SetThemes(Sel.Style.Dark, main);
                            main.Dark();
                            LogManager.Add("Now", "Sync system theme, set to: Dark");
                        }
                        break;
                    case "Light":
                        if ((string)Cfg.UI.GetValue("isDark") != "Light")
                        {
                            SetThemes(Sel.Style.Light, main);
                            main.Dark();
                            LogManager.Add("Now", "Sync system theme, set to: Light");
                        }
                        break;
                }

                Thread.Sleep(1000);
            }
        }
    }
}