﻿using System;
using System.Drawing;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace WNMP
{
    public partial class Port : Form
    {
        readonly MainInterface main;
        readonly Sel.Type Page;

        public Port(MainInterface m, Sel.Type page)
        {
            InitializeComponent();
            main = m;
            Page = page;

            switch (page)
            {
                case Sel.Type.Nginx:
                    page_1.Visible = true;
                    page_2.Visible = false;
                    page_3.Visible = false;
                    break;
                case Sel.Type.Php:
                    page_1.Visible = false;
                    page_2.Visible = true;
                    page_3.Visible = false;
                    break;
                case Sel.Type.MySql:
                    page_1.Visible = false;
                    page_2.Visible = false;
                    page_3.Visible = true;
                    break;
            }
        }

        private void SetLanguage()
        {
            port_page_readme.Text = Lp.Get("port_page_readme");

            // tab_page_nginx
            nginx_http_port.Text = "Http " + Lp.Get("port_page_title");
            nginx_https_port.Text = "Https " + Lp.Get("port_page_title");
            nginx_http_port_post.Text = (string)Cfg.Nginx.GetValue("nginx_http_port");
            nginx_https_port_post.Text = (string)Cfg.Nginx.GetValue("nginx_https_port");

            php_port.Text = "PHP " + Lp.Get("port_page_title");
            mysql_port.Text = "MySQL " + Lp.Get("port_page_title");
            Close_Canel.Text = Lp.Get("cancel");
            OK.Text = Lp.Get("ok");

            switch (Lp.Lang)
            {
                case "en-US":
                    this.Size = new Size(480, 310);
                    break;
                case "zh-CN":
                    this.Size = new Size(480, 280);
                    break;
            }
        }

        private void Dark()
        {
            switch ((string)Cfg.UI.GetValue("isDark"))
            {
                case "Dark":
                    this.Icon = global::WNMP.Properties.Resources.Yi_white;
                    break;
                case "Light":
                    this.Icon = global::WNMP.Properties.Resources.Yi;
                    break;
            }
            Skin.ChangeControl(this);
        }

        private void GetConfig()
        {
            php_port_post.Text = (string)Cfg.Php.GetValue("php_port");
            var myini = Cfg.MD + "\\mysql\\data\\my.ini";
            if (File.Exists(myini))
            {
                IniFile ini_file;
                ini_file = new IniFile();
                ini_file.Load(myini);
                var port = ini_file.GetKeyValue("mysqld", "port");
                mysql_port_post.Text = port;
            }
            else
            {
                mysql_port_post.Enabled = false;
                msg_mysql_error.Text = "my.ini " + Lp.Get("Msg_no_sync_config");
            }
        }

        private void Port_Load(object sender, EventArgs e)
        {
            SetLanguage();
            Dark();
            GetConfig();
        }

        private void OK_Click(object sender, EventArgs e)
        {
            switch (Page)
            {
                case Sel.Type.Nginx:
                    msg_nginx_http_error.Text = "";
                    msg_nginx_https_error.Text = "";
                    if (IsPort(nginx_http_port_post.Text))
                    {
                        Cfg.Nginx.SetValue("nginx_http_port", nginx_http_port_post.Text);
                        msg_nginx_http_error.Text = "Http " + Lp.Get("port_page_change_done");
                        main.Msg(Sel.Type.Nginx, "Http " + Lp.Get("port_page_change_done"));
                    }
                    else
                    {
                        msg_nginx_http_error.Text = Lp.Get("port_page_change_error");
                    }

                    if (IsPort(nginx_https_port_post.Text))
                    {
                        Cfg.Nginx.SetValue("nginx_https_port", nginx_https_port_post.Text);
                        msg_nginx_https_error.Text = "Https " + Lp.Get("port_page_change_done");
                        main.Msg(Sel.Type.Nginx, "Https " + Lp.Get("port_page_change_done"));
                    }
                    else
                    {
                        msg_nginx_https_error.Text = Lp.Get("port_page_change_error");
                    }
                    break;
                case Sel.Type.Php:
                    msg_php_error.Text = "";
                    if (IsPort(php_port_post.Text))
                    {
                        Cfg.Php.SetValue("php_port", php_port_post.Text);
                        msg_php_error.Text = "PHP " + Lp.Get("port_page_change_done");
                        main.Msg(Sel.Type.Service, Lp.Get("port_page_change_done"));
                    }
                    else
                    {
                        msg_php_error.Text = Lp.Get("port_page_change_error");
                    }
                    break;
                case Sel.Type.MySql:
                    msg_mysql_error.Text = "";
                    if (IsPort(mysql_port_post.Text))
                    {
                        if (File.Exists(Cfg.myini))
                        {
                            IniFile ini_file;
                            ini_file = new IniFile();
                            ini_file.Load(Cfg.myini);
                            ini_file.SetKeyValue("mysqld", "port", mysql_port_post.Text);
                            ini_file.SetKeyValue("client", "port", mysql_port_post.Text);
                            ini_file.Save(Cfg.myini);
                            msg_mysql_error.Text = "MySQL " + Lp.Get("port_page_change_done");
                            main.Msg(Sel.Type.MySql, Lp.Get("port_page_change_done"));
                        }
                        else
                        {
                            main.Msg(Sel.Type.MySql, Lp.Get("Msg_no_sync_config"));
                            msg_mysql_error.Text = "my.ini " + Lp.Get("Msg_no_sync_config");
                            return;
                        }

                    }
                    else
                    {
                        msg_mysql_error.Text = Lp.Get("port_page_change_error");
                    }
                    break;
            }
        }

        private void Close_Canel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        public static bool IsPort(string value)
        {
            if (string.IsNullOrEmpty(value))
                return false;

            Regex numeric = new Regex(@"^[0-9]+$", RegexOptions.Compiled | RegexOptions.IgnoreCase);

            if (numeric.IsMatch(value))
            {
                try
                {
                    if (Convert.ToInt32(value) < 65536)
                        return true;
                }
                catch (OverflowException)
                {
                }
            }

            return false;
        }
    }
}