﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace WNMP
{
    public partial class IsCloseQuick : Form
    {
        public readonly MainInterface main;

        public IsCloseQuick(MainInterface m)
        {
            InitializeComponent();
            main = m;
        }

        private void SetLanguage()
        {
            click_close_button.Text = Lp.Get("select_close_button");
            Close_Select_App_Exit.Text = Lp.Get("tab_setting_Close_Select_App_Exit");
            Close_All_App_Exit.Text = Lp.Get("tab_setting_Close_All_App_Exit");
            Close_Exit.Text = Lp.Get("tab_setting_Close_Exit");
            Close_Canel.Text = Lp.Get("cancel");
            OK.Text = Lp.Get("ok");

            switch (Lp.Lang)
            {
                case "en-US":
                    this.Size = new Size(450, 220);
                    break;
                case "zh-CN":
                    this.Size = new Size(365, 220);
                    break;
            }
        }

        private void Dark()
        {
            switch ((string)Cfg.UI.GetValue("isDark"))
            {
                case "Dark":
                    this.Icon = global::WNMP.Properties.Resources.Yi_white;
                    HIPS.Image = global::WNMP.Properties.Resources.hips_dark;
                    break;
                case "Light":
                    this.Icon = global::WNMP.Properties.Resources.Yi;
                    HIPS.Image = global::WNMP.Properties.Resources.hips;
                    break;
            }
            Skin.ChangeControl(this);
        }

        private void MainClose_Load(object sender, EventArgs e)
        {
            Cfg.close_save = false;
            Cfg.isShowHide = false;
            SetLanguage();
            Dark();

            if ((string)Cfg.UI.GetValue("After_Closing_Last") != "Exit" &&
                (string)Cfg.UI.GetValue("After_Closing_Last") != "Select" &&
                (string)Cfg.UI.GetValue("After_Closing_Last") != "ExitAll")
            {
                Cfg.UI.SetValue("After_Closing_Last", "Exit");
            }

            #region 关闭面板时
            switch ((string)Cfg.UI.GetValue("After_Closing_Last"))
            {
                case "Select":
                    Close_Select_App_Exit.Checked = true;
                    break;
                case "Exit":
                    Close_Exit.Checked = true;
                    break;
                case "ExitAll":
                    Close_All_App_Exit.Checked = true;
                    break;
            }
            #endregion
        }

        private void OK_Click(object sender, EventArgs e)
        {
            if (Close_Select_App_Exit.Checked)
            {
                if (main.Start_App_Php.Checked)
                {
                    BPT.Killprocess("Yi_php");
                }
                if (main.Start_App_MySql.Checked)
                {
                    BPT.Killprocess("Yi_mysqld");
                }
                if (main.Start_App_Nginx.Checked)
                {
                    BPT.Killprocess("Yi_nginx");
                }

                Application.Exit();
            }

            if (Close_Exit.Checked)
            {
                Application.Exit();
            }

            if (Close_All_App_Exit.Checked)
            {
                BPT.Killprocess("Yi_php");
                BPT.Killprocess("Yi_mysqld");
                BPT.Killprocess("Yi_nginx");

                Application.Exit();
            }

            this.Close();
        }

        private void Close_Canel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Close_Select_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Select_App_Exit.Checked)
            {
                Cfg.UI.SetValue("After_Closing_Last", "Select");
            }
        }

        private void Close_All_App_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_All_App_Exit.Checked)
            {
                Cfg.UI.SetValue("After_Closing_Last", "ExitAll");
            }
        }

        private void Close_Exit_CheckedChanged(object sender, EventArgs e)
        {
            if (Close_Exit.Checked)
            {
                Cfg.UI.SetValue("After_Closing_Last", "Exit");
            }
        }
    }
}
