﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Threading;

public class LogManager
{
	private static readonly Queue<Log> ListQueue = new Queue<Log>();
	private static readonly object _lock = new object();

	static LogManager()
	{
		Start();
	}

	class Log
	{
		public string Name { get; set; }
		public string Time { get; set; }
		public string Msg { get; set; }
	}

	public static void WriteLog(string logFile, string logTime, string logMsg)
	{
		var NlogTime = logTime;

		if (NlogTime == "Now")
			NlogTime = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss fff");

		Log log = new Log()
		{
			Name = logFile,
			Time = NlogTime,
			Msg = logMsg
		};
		lock (_lock)
		{
			ListQueue.Enqueue(log);
		}
	}

	private static void Start()
	{
		WriteLog("Startup", "Now", "start");
		Thread thread = new Thread(ThreadStart)
		{
			IsBackground = true
		};
		thread.Start();
	}

	private static void ThreadStart()
	{
		while (true)
		{
			if (ListQueue.Count > 0)
			{
				try
				{
					ScanQueue();
				}
				catch (Exception)
				{
					throw;
				}
			}
			else
			{
				Thread.Sleep(3000);
			}
		}
	}

	private static void ScanQueue()
	{
		while (ListQueue.Count > 0)
		{
			try
			{
				Log log = ListQueue.Dequeue();
				ThreadLog(log.Name, log.Time, log.Msg);
			}
			catch (Exception)
			{
				throw;
			}
		}
	}

	#region 保存日志的文件夹
	private static string logPath = string.Empty;
	public static string LogPath
	{
		get
		{
			if (logPath == string.Empty)
			{
				logPath = Cfg.RoamingPath + "\\logs\\";
				if (!Directory.Exists(logPath))
					Directory.CreateDirectory(logPath);
			}
			return logPath;
		}
		set { logPath = value; }
	}
	#endregion

	#region 线程最后一步，写入日志到文件
	private static void ThreadLog(string FName, string NTime, string msg)
	{
		try
		{
			using (FileStream fileStream = new FileStream(LogPath + FName + ".log", FileMode.Append))
			{
				using (StreamWriter log = new StreamWriter(fileStream))
				{
					log.WriteLine(NTime + " " + msg);
					log.Close();
				}
			}
		}
		catch
		{ }
	}
	#endregion

	#region 获取日期及判断是否同一天，不同则重新生成。
	public static void TimeVerify()
	{
		if ((string)Cfg.Log.GetValue("Name") == null)
			Cfg.Log.SetValue("Name", DateTime.Now.ToString("yyyyMMddHHmmssffff"));

		DateTime d = DateTime.ParseExact((string)Cfg.Log.GetValue("Name"), "yyyyMMddHHmmssffff", null);
		if (d.ToString("yyyyMMdd") != DateTime.Now.ToString("yyyyMMdd"))
			Cfg.Log.SetValue("Name", DateTime.Now.ToString("yyyyMMddHHmmssffff"));
	}
	#endregion

	public static void Add(string nTime, string Msg)
	{
		TimeVerify();
		if ((string)Cfg.Log.GetValue("isSave_Local") == "On")
			WriteLog((string)Cfg.Log.GetValue("Name"), nTime, Msg);
	}

	public static void Clear()
	{
		if ((string)Cfg.Log.GetValue("isSave_log") == "On")
		{
			DirectoryInfo logDirInfo = new DirectoryInfo(Cfg.RoamingPath + "\\logs");
			if (!logDirInfo.Exists)
				logDirInfo.Create();

			foreach (FileInfo fi in logDirInfo.GetFiles())
			{
				var creationTime = fi.CreationTime;

				if (creationTime < (DateTime.Now - new TimeSpan((int)Cfg.Log.GetValue("isLog_Time"), 0, 0, 0)))
				{
					fi.Delete();
				}
			}
		}
	}
}